@echo off
echo ====================================
echo Law Firm ERP v2 - Environment Setup
echo ====================================
echo.

if exist .env (
    echo .env file already exists!
    choice /C YN /M "Do you want to overwrite it"
    if errorlevel 2 goto END
)

echo Creating .env file...
(
echo NODE_ENV=development
echo PORT=8080
echo HOST=localhost
echo.
echo DB_HOST=localhost
echo DB_PORT=3306
echo DB_USER=root
echo DB_PASSWORD=
echo DB_NAME=lawfirmV2_db
echo.
echo SESSION_SECRET=%RANDOM%%RANDOM%%RANDOM%%RANDOM%%RANDOM%%RANDOM%%RANDOM%%RANDOM%
echo SESSION_MAX_AGE=86400000
echo.
echo RATE_LIMIT_WINDOW_MS=900000
echo RATE_LIMIT_MAX_REQUESTS=100
echo.
echo CORS_ORIGIN=http://localhost:5173
echo.
echo LOG_LEVEL=info
) > .env

echo.
echo ✓ .env file created successfully!
echo.
echo IMPORTANT: Please edit .env and:
echo   1. Set a secure SESSION_SECRET (auto-generated, but verify)
echo   2. Update DB_PASSWORD if your MySQL has a password
echo.

:END
pause
