import { z } from 'zod';

// Login DTO
export const loginSchema = z.object({
  body: z.object({
    username: z.string().min(1, 'Username is required'),
    password: z.string().min(1, 'Password is required'),
  }),
});

export type LoginDto = z.infer<typeof loginSchema>['body'];

// Auth response type
export interface AuthResponse {
  user: {
    id: number;
    username: string;
    employee_id: number;
    employee_name: string;
    department_id: number;
    department_name: string;
    role_id: number;
    role_name: string;
  };
}
