import { z } from 'zod';

// Create department DTO
export const createDepartmentSchema = z.object({
  body: z.object({
    name: z.string().min(1, 'Department name is required').max(100, 'Name too long'),
    description: z.string().optional(),
  }),
});

// Update department DTO
export const updateDepartmentSchema = z.object({
  params: z.object({
    id: z.string().regex(/^\d+$/, 'Invalid department ID'),
  }),
  body: z.object({
    name: z.string().min(1, 'Department name is required').max(100, 'Name too long').optional(),
    description: z.string().optional(),
  }),
});

// Delete department DTO
export const deleteDepartmentSchema = z.object({
  params: z.object({
    id: z.string().regex(/^\d+$/, 'Invalid department ID'),
  }),
});

// Get department DTO
export const getDepartmentSchema = z.object({
  params: z.object({
    id: z.string().regex(/^\d+$/, 'Invalid department ID'),
  }),
});

export type CreateDepartmentDto = z.infer<typeof createDepartmentSchema>['body'];
export type UpdateDepartmentDto = z.infer<typeof updateDepartmentSchema>['body'];

export interface DepartmentResponse {
  id: number;
  name: string;
  description: string | null;
  created_at: Date;
}
