# Test authentication endpoints

Write-Host "================================" -ForegroundColor Cyan
Write-Host "Testing Authentication API" -ForegroundColor Cyan
Write-Host "================================" -ForegroundColor Cyan
Write-Host ""

# Test 1: Login with admin credentials
Write-Host "Test 1: Login as admin" -ForegroundColor Yellow
$loginBody = @{
    username = "admin"
    password = "password"
} | ConvertTo-Json

try {
    $response = Invoke-WebRequest -Uri "http://localhost:8080/api/auth/login" `
        -Method POST `
        -ContentType "application/json" `
        -Body $loginBody `
        -SessionVariable session

    Write-Host "[OK] Login successful!" -ForegroundColor Green
    $responseData = $response.Content | ConvertFrom-Json
    Write-Host "User:" $responseData.data.user.username -ForegroundColor Green
    Write-Host "Role:" $responseData.data.user.role_name -ForegroundColor Green
    Write-Host "Department:" $responseData.data.user.department_name -ForegroundColor Green
    Write-Host ""

    # Test 2: Get current user info
    Write-Host "Test 2: Get current user (/api/auth/me)" -ForegroundColor Yellow
    $meResponse = Invoke-WebRequest -Uri "http://localhost:8080/api/auth/me" `
        -Method GET `
        -WebSession $session

    $meData = $meResponse.Content | ConvertFrom-Json
    Write-Host "[OK] Current user retrieved!" -ForegroundColor Green
    Write-Host "Employee Name:" $meData.data.user.employee_name -ForegroundColor Green
    Write-Host ""

    # Test 3: Logout
    Write-Host "Test 3: Logout" -ForegroundColor Yellow
    $logoutResponse = Invoke-WebRequest -Uri "http://localhost:8080/api/auth/logout" `
        -Method POST `
        -WebSession $session

    Write-Host "[OK] Logout successful!" -ForegroundColor Green
    Write-Host ""

} catch {
    Write-Host "[FAIL] Test failed:" $_.Exception.Message -ForegroundColor Red
    if ($_.Exception.Response) {
        $reader = [System.IO.StreamReader]::new($_.Exception.Response.GetResponseStream())
        $errorBody = $reader.ReadToEnd()
        Write-Host "Error response:" $errorBody -ForegroundColor Red
    }
}

# Test 4: Invalid credentials
Write-Host "Test 4: Login with invalid credentials (should fail)" -ForegroundColor Yellow
$invalidBody = @{
    username = "admin"
    password = "wrongpassword"
} | ConvertTo-Json

try {
    $response = Invoke-WebRequest -Uri "http://localhost:8080/api/auth/login" `
        -Method POST `
        -ContentType "application/json" `
        -Body $invalidBody
    
    Write-Host "[FAIL] Should have failed but did not!" -ForegroundColor Red
} catch {
    if ($_.Exception.Response.StatusCode -eq 401) {
        Write-Host "[OK] Correctly rejected invalid credentials (401)" -ForegroundColor Green
    } else {
        Write-Host "[FAIL] Unexpected status code:" $_.Exception.Response.StatusCode -ForegroundColor Red
    }
}

Write-Host ""
Write-Host "================================" -ForegroundColor Cyan
Write-Host "Authentication Tests Complete!" -ForegroundColor Cyan
Write-Host "================================" -ForegroundColor Cyan
