import dotenv from 'dotenv';
import { z } from 'zod';
dotenv.config();
const configSchema = z.object({
    NODE_ENV: z.enum(['development', 'production', 'test']).default('development'),
    // PORT: z.string().transform(Number).default('8080'),
    // Railway MUST use process.env.PORT
    PORT: z.string().default(process.env.PORT || '3000').transform(Number),
    // HOST: z.string().default('localhost'),
    // Railway requires 0.0.0.0
    HOST: z.string().default('0.0.0.0'),
    // DB_HOST: z.string().default('localhost'),
    DB_HOST: z.string().default('0.0.0.0'), // (ignored on Railway because env will override)
    DB_PORT: z.string().transform(Number).default('3306'),
    DB_USER: z.string().default('root'),
    DB_PASSWORD: z.string().default(''),
    DB_NAME: z.string().default('lawfirmV2_db'),
    SESSION_SECRET: z.string().min(32),
    SESSION_MAX_AGE: z.string().transform(Number).default('86400000'),
    RATE_LIMIT_WINDOW_MS: z.string().transform(Number).default('900000'),
    RATE_LIMIT_MAX_REQUESTS: z.string().transform(Number).default('100'),
    CORS_ORIGIN: z.string().default('http://localhost:5173'),
    LOG_LEVEL: z.enum(['fatal', 'error', 'warn', 'info', 'debug', 'trace']).default('info'),
});
const parseConfig = () => {
    try {
        return configSchema.parse(process.env);
    }
    catch (error) {
        if (error instanceof z.ZodError) {
            console.error('Invalid environment configuration:');
            error.errors.forEach((err) => {
                console.error(`  - ${err.path.join('.')}: ${err.message}`);
            });
            process.exit(1);
        }
        throw error;
    }
};
export const config = parseConfig();
//# sourceMappingURL=config.js.map