import mysql from 'mysql2/promise';
import { config } from '../config.js';
import { logger } from '../utils/logger.js';
let pool = null;
export async function createPool() {
    if (pool) {
        return pool;
    }
    try {
        pool = mysql.createPool({
            host: config.DB_HOST,
            port: config.DB_PORT,
            user: config.DB_USER,
            password: config.DB_PASSWORD,
            database: config.DB_NAME,
            waitForConnections: true,
            connectionLimit: 10,
            queueLimit: 0,
            enableKeepAlive: true,
            keepAliveInitialDelay: 0,
            charset: 'utf8mb4',
        });
        // Test connection
        const connection = await pool.getConnection();
        console.log('✅ Database connection established');
        logger.info('✓ Database connection established');
        connection.release();
        return pool;
    }
    catch (error) {
        console.error('❌ Failed to create database pool:', error);
        logger.error({ err: error }, 'Failed to create database pool');
        throw error;
    }
}
export async function getPool() {
    if (!pool) {
        return createPool();
    }
    return pool;
}
export async function closePool() {
    if (pool) {
        await pool.end();
        pool = null;
        logger.info('Database pool closed');
    }
}
//# sourceMappingURL=pool.js.map