import { z } from 'zod';
export declare const loginSchema: z.ZodObject<{
    body: z.ZodObject<{
        username: z.ZodString;
        password: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        password: string;
        username: string;
    }, {
        password: string;
        username: string;
    }>;
}, "strip", z.ZodTypeAny, {
    body: {
        password: string;
        username: string;
    };
}, {
    body: {
        password: string;
        username: string;
    };
}>;
export type LoginDto = z.infer<typeof loginSchema>['body'];
export interface AuthResponse {
    user: {
        id: number;
        username: string;
        employee_id: number;
        employee_name: string;
        department_id: number;
        department_name: string;
        role_id: number;
        role_name: string;
    };
}
//# sourceMappingURL=dto.d.ts.map