export interface UserRecord {
    id: number;
    username: string;
    password_hash: string;
    employee_id: number;
    employee_name: string;
    department_id: number;
    department_name: string;
    role_id: number;
    role_name: string;
    is_active: number;
}
export interface SessionRecord {
    id: string;
    user_id: number;
    expires_at: Date;
}
export declare class AuthRepository {
    /**
     * Find user by username with all related data
     */
    findUserByUsername(username: string): Promise<UserRecord | null>;
    /**
     * Verify user credentials
     */
    verifyCredentials(username: string, password: string): Promise<UserRecord | null>;
    /**
     * Create a new session
     */
    createSession(userId: number, ip: string, userAgent: string): Promise<SessionRecord>;
    /**
     * Get session by ID
     */
    getSession(sessionId: string): Promise<SessionRecord | null>;
    /**
     * Delete session (logout)
     */
    deleteSession(sessionId: string): Promise<void>;
    /**
     * Delete all expired sessions (cleanup)
     */
    deleteExpiredSessions(): Promise<number>;
    /**
     * Log authentication event to audit log
     */
    logAuthEvent(userId: number | null, action: 'LOGIN' | 'LOGOUT', meta: Record<string, any>): Promise<void>;
}
//# sourceMappingURL=repo.d.ts.map