import { z } from 'zod';
export declare const runConflictCheckSchema: z.ZodObject<{
    body: z.ZodObject<{
        matter_id: z.ZodNumber;
        search_queries: z.ZodArray<z.ZodString, "many">;
        check_client: z.ZodDefault<z.ZodBoolean>;
        check_parties: z.ZodDefault<z.ZodBoolean>;
        check_counsel: z.ZodDefault<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        matter_id: number;
        search_queries: string[];
        check_client: boolean;
        check_parties: boolean;
        check_counsel: boolean;
    }, {
        matter_id: number;
        search_queries: string[];
        check_client?: boolean | undefined;
        check_parties?: boolean | undefined;
        check_counsel?: boolean | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    body: {
        matter_id: number;
        search_queries: string[];
        check_client: boolean;
        check_parties: boolean;
        check_counsel: boolean;
    };
}, {
    body: {
        matter_id: number;
        search_queries: string[];
        check_client?: boolean | undefined;
        check_parties?: boolean | undefined;
        check_counsel?: boolean | undefined;
    };
}>;
export declare const getConflictCheckSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
}, {
    params: {
        id: string;
    };
}>;
export declare const overrideConflictSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        justification: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        justification: string;
    }, {
        justification: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
    body: {
        justification: string;
    };
}, {
    params: {
        id: string;
    };
    body: {
        justification: string;
    };
}>;
export declare const getMatterConflictsSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
}, {
    params: {
        id: string;
    };
}>;
export type RunConflictCheckDto = z.infer<typeof runConflictCheckSchema>['body'];
export type OverrideConflictDto = z.infer<typeof overrideConflictSchema>['body'];
export interface ConflictMatch {
    matter_id: number;
    matter_number: string;
    case_type: string;
    party_name: string;
    party_type: string;
    match_type: 'Exact' | 'Fuzzy' | 'Related';
    similarity_score: number;
    identifier_match: boolean;
}
export interface ConflictCheckResult {
    query: string;
    matches: ConflictMatch[];
    conflict_level: 'None' | 'Name Similar' | 'Indirect' | 'Direct';
}
export interface ConflictCheckResponse {
    id: number;
    matter_id: number;
    check_query: string;
    run_by: number;
    run_by_name: string;
    run_at: string;
    result_count: number;
    result_summary: string | null;
    conflict_level: string;
    override_flag: boolean;
    override_by: number | null;
    override_by_name: string | null;
    override_at: string | null;
    override_justification: string | null;
    results: ConflictCheckResult[];
}
//# sourceMappingURL=dto.d.ts.map