import { z } from 'zod';
// ====================
// Request Schemas
// ====================
export const runConflictCheckSchema = z.object({
    body: z.object({
        matter_id: z.number().int().positive(),
        search_queries: z.array(z.string().min(2)).min(1, 'At least one search query required'),
        check_client: z.boolean().default(true),
        check_parties: z.boolean().default(true),
        check_counsel: z.boolean().default(true),
    }),
});
export const getConflictCheckSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
});
export const overrideConflictSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
    body: z.object({
        justification: z.string().min(10, 'Justification must be at least 10 characters'),
    }),
});
export const getMatterConflictsSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
});
//# sourceMappingURL=dto.js.map