import { ConflictCheckResult, ConflictCheckResponse, RunConflictCheckDto } from './dto.js';
export declare class ConflictRepository {
    private service;
    constructor();
    /**
     * Run comprehensive conflict check
     * Searches across all parties in all matters for potential conflicts
     */
    runConflictCheck(matterId: number, data: RunConflictCheckDto, userId: number): Promise<{
        checkId: number;
        results: ConflictCheckResult[];
    }>;
    /**
     * Search for conflicts across all matters and parties
     * Returns matches with similarity scoring
     */
    private searchConflicts;
    /**
     * Remove duplicate matches (same matter + party)
     */
    private deduplicateMatches;
    /**
     * Get conflict check by ID with full results
     */
    findById(id: number): Promise<ConflictCheckResponse | null>;
    /**
     * Get all conflict checks for a matter
     */
    findByMatterId(matterId: number): Promise<ConflictCheckResponse[]>;
    /**
     * Override a conflict check (partner approval)
     */
    overrideConflict(checkId: number, userId: number, justification: string): Promise<boolean>;
}
//# sourceMappingURL=repo.d.ts.map