import { ConflictMatch, ConflictCheckResult } from './dto.js';
export declare class ConflictService {
    /**
     * Calculate Levenshtein distance (edit distance) between two strings
     * Used for fuzzy name matching
     */
    private levenshteinDistance;
    /**
     * Calculate similarity score (0-1) based on Levenshtein distance
     * 1 = identical, 0 = completely different
     */
    calculateSimilarity(str1: string, str2: string): number;
    /**
     * Determine if two names are similar based on similarity threshold
     * Threshold: 0.8 = 80% similar
     */
    isSimilarName(name1: string, name2: string, threshold?: number): boolean;
    /**
     * Determine conflict level based on matches
     * Rules:
     * - Direct: Same client or party appears as adverse party in another matter
     * - Indirect: Related party or counsel appears in another matter
     * - Name Similar: Names are similar but not exact (fuzzy match)
     * - None: No conflicts found
     */
    determineConflictLevel(matches: ConflictMatch[]): 'None' | 'Name Similar' | 'Indirect' | 'Direct';
    /**
     * Generate result summary text
     */
    generateResultSummary(results: ConflictCheckResult[]): string;
    /**
     * Determine overall conflict level from multiple results
     */
    determineOverallConflictLevel(results: ConflictCheckResult[]): 'None' | 'Name Similar' | 'Indirect' | 'Direct';
    /**
     * Normalize name for comparison (remove extra spaces, lowercase)
     */
    normalizeName(name: string): string;
}
//# sourceMappingURL=service.d.ts.map