import { z } from 'zod';
export declare const createCourtCalendarSchema: z.ZodObject<{
    body: z.ZodObject<{
        matter_id: z.ZodNumber;
        hearing_id: z.ZodOptional<z.ZodNumber>;
        court_type_id: z.ZodOptional<z.ZodNumber>;
        court_level: z.ZodEnum<["District Court", "Circuit Court", "High Court", "Court of Appeal", "Supreme Court"]>;
        court_location: z.ZodString;
        court_room: z.ZodOptional<z.ZodString>;
        judge_name: z.ZodOptional<z.ZodString>;
        docket_number: z.ZodOptional<z.ZodString>;
        hearing_date: z.ZodString;
        hearing_time: z.ZodOptional<z.ZodString>;
        hearing_type: z.ZodDefault<z.ZodEnum<["Hearing", "Motion", "Trial", "Ruling", "Judgment", "Mention", "Case Management", "Other"]>>;
        duration_minutes: z.ZodDefault<z.ZodOptional<z.ZodNumber>>;
        assigned_lawyer_id: z.ZodNumber;
        notes: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        matter_id: number;
        court_level: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court";
        court_location: string;
        hearing_date: string;
        hearing_type: "Other" | "Hearing" | "Motion" | "Trial" | "Ruling" | "Judgment" | "Mention" | "Case Management";
        duration_minutes: number;
        assigned_lawyer_id: number;
        notes?: string | undefined;
        hearing_id?: number | undefined;
        court_type_id?: number | undefined;
        court_room?: string | undefined;
        judge_name?: string | undefined;
        docket_number?: string | undefined;
        hearing_time?: string | undefined;
    }, {
        matter_id: number;
        court_level: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court";
        court_location: string;
        hearing_date: string;
        assigned_lawyer_id: number;
        notes?: string | undefined;
        hearing_id?: number | undefined;
        court_type_id?: number | undefined;
        court_room?: string | undefined;
        judge_name?: string | undefined;
        docket_number?: string | undefined;
        hearing_time?: string | undefined;
        hearing_type?: "Other" | "Hearing" | "Motion" | "Trial" | "Ruling" | "Judgment" | "Mention" | "Case Management" | undefined;
        duration_minutes?: number | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    body: {
        matter_id: number;
        court_level: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court";
        court_location: string;
        hearing_date: string;
        hearing_type: "Other" | "Hearing" | "Motion" | "Trial" | "Ruling" | "Judgment" | "Mention" | "Case Management";
        duration_minutes: number;
        assigned_lawyer_id: number;
        notes?: string | undefined;
        hearing_id?: number | undefined;
        court_type_id?: number | undefined;
        court_room?: string | undefined;
        judge_name?: string | undefined;
        docket_number?: string | undefined;
        hearing_time?: string | undefined;
    };
}, {
    body: {
        matter_id: number;
        court_level: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court";
        court_location: string;
        hearing_date: string;
        assigned_lawyer_id: number;
        notes?: string | undefined;
        hearing_id?: number | undefined;
        court_type_id?: number | undefined;
        court_room?: string | undefined;
        judge_name?: string | undefined;
        docket_number?: string | undefined;
        hearing_time?: string | undefined;
        hearing_type?: "Other" | "Hearing" | "Motion" | "Trial" | "Ruling" | "Judgment" | "Mention" | "Case Management" | undefined;
        duration_minutes?: number | undefined;
    };
}>;
export declare const updateCourtCalendarSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        court_type_id: z.ZodOptional<z.ZodNumber>;
        court_level: z.ZodOptional<z.ZodEnum<["District Court", "Circuit Court", "High Court", "Court of Appeal", "Supreme Court"]>>;
        court_location: z.ZodOptional<z.ZodString>;
        court_room: z.ZodOptional<z.ZodString>;
        judge_name: z.ZodOptional<z.ZodString>;
        docket_number: z.ZodOptional<z.ZodString>;
        hearing_date: z.ZodOptional<z.ZodString>;
        hearing_time: z.ZodOptional<z.ZodString>;
        hearing_type: z.ZodOptional<z.ZodEnum<["Hearing", "Motion", "Trial", "Ruling", "Judgment", "Mention", "Case Management", "Other"]>>;
        duration_minutes: z.ZodOptional<z.ZodNumber>;
        status: z.ZodOptional<z.ZodEnum<["Scheduled", "Confirmed", "Postponed", "Completed", "Cancelled"]>>;
        assigned_lawyer_id: z.ZodOptional<z.ZodNumber>;
        notes: z.ZodOptional<z.ZodString>;
        postponement_reason: z.ZodOptional<z.ZodString>;
        outcome: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        status?: "Scheduled" | "Confirmed" | "Postponed" | "Completed" | "Cancelled" | undefined;
        notes?: string | undefined;
        court_type_id?: number | undefined;
        court_level?: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court" | undefined;
        court_location?: string | undefined;
        court_room?: string | undefined;
        judge_name?: string | undefined;
        docket_number?: string | undefined;
        hearing_date?: string | undefined;
        hearing_time?: string | undefined;
        hearing_type?: "Other" | "Hearing" | "Motion" | "Trial" | "Ruling" | "Judgment" | "Mention" | "Case Management" | undefined;
        duration_minutes?: number | undefined;
        assigned_lawyer_id?: number | undefined;
        postponement_reason?: string | undefined;
        outcome?: string | undefined;
    }, {
        status?: "Scheduled" | "Confirmed" | "Postponed" | "Completed" | "Cancelled" | undefined;
        notes?: string | undefined;
        court_type_id?: number | undefined;
        court_level?: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court" | undefined;
        court_location?: string | undefined;
        court_room?: string | undefined;
        judge_name?: string | undefined;
        docket_number?: string | undefined;
        hearing_date?: string | undefined;
        hearing_time?: string | undefined;
        hearing_type?: "Other" | "Hearing" | "Motion" | "Trial" | "Ruling" | "Judgment" | "Mention" | "Case Management" | undefined;
        duration_minutes?: number | undefined;
        assigned_lawyer_id?: number | undefined;
        postponement_reason?: string | undefined;
        outcome?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
    body: {
        status?: "Scheduled" | "Confirmed" | "Postponed" | "Completed" | "Cancelled" | undefined;
        notes?: string | undefined;
        court_type_id?: number | undefined;
        court_level?: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court" | undefined;
        court_location?: string | undefined;
        court_room?: string | undefined;
        judge_name?: string | undefined;
        docket_number?: string | undefined;
        hearing_date?: string | undefined;
        hearing_time?: string | undefined;
        hearing_type?: "Other" | "Hearing" | "Motion" | "Trial" | "Ruling" | "Judgment" | "Mention" | "Case Management" | undefined;
        duration_minutes?: number | undefined;
        assigned_lawyer_id?: number | undefined;
        postponement_reason?: string | undefined;
        outcome?: string | undefined;
    };
}, {
    params: {
        id: string;
    };
    body: {
        status?: "Scheduled" | "Confirmed" | "Postponed" | "Completed" | "Cancelled" | undefined;
        notes?: string | undefined;
        court_type_id?: number | undefined;
        court_level?: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court" | undefined;
        court_location?: string | undefined;
        court_room?: string | undefined;
        judge_name?: string | undefined;
        docket_number?: string | undefined;
        hearing_date?: string | undefined;
        hearing_time?: string | undefined;
        hearing_type?: "Other" | "Hearing" | "Motion" | "Trial" | "Ruling" | "Judgment" | "Mention" | "Case Management" | undefined;
        duration_minutes?: number | undefined;
        assigned_lawyer_id?: number | undefined;
        postponement_reason?: string | undefined;
        outcome?: string | undefined;
    };
}>;
export declare const getCourtCalendarSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
}, {
    params: {
        id: string;
    };
}>;
export declare const listCourtCalendarsSchema: z.ZodObject<{
    query: z.ZodObject<{
        page: z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodString, number, string>>>;
        limit: z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodString, number, string>>>;
        matter_id: z.ZodOptional<z.ZodEffects<z.ZodString, number, string>>;
        lawyer_id: z.ZodOptional<z.ZodEffects<z.ZodString, number, string>>;
        court_location: z.ZodOptional<z.ZodString>;
        start_date: z.ZodOptional<z.ZodString>;
        end_date: z.ZodOptional<z.ZodString>;
        status: z.ZodOptional<z.ZodEnum<["Scheduled", "Confirmed", "Postponed", "Completed", "Cancelled"]>>;
    }, "strip", z.ZodTypeAny, {
        page: number;
        limit: number;
        status?: "Scheduled" | "Confirmed" | "Postponed" | "Completed" | "Cancelled" | undefined;
        lawyer_id?: number | undefined;
        matter_id?: number | undefined;
        court_location?: string | undefined;
        start_date?: string | undefined;
        end_date?: string | undefined;
    }, {
        status?: "Scheduled" | "Confirmed" | "Postponed" | "Completed" | "Cancelled" | undefined;
        lawyer_id?: string | undefined;
        page?: string | undefined;
        limit?: string | undefined;
        matter_id?: string | undefined;
        court_location?: string | undefined;
        start_date?: string | undefined;
        end_date?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    query: {
        page: number;
        limit: number;
        status?: "Scheduled" | "Confirmed" | "Postponed" | "Completed" | "Cancelled" | undefined;
        lawyer_id?: number | undefined;
        matter_id?: number | undefined;
        court_location?: string | undefined;
        start_date?: string | undefined;
        end_date?: string | undefined;
    };
}, {
    query: {
        status?: "Scheduled" | "Confirmed" | "Postponed" | "Completed" | "Cancelled" | undefined;
        lawyer_id?: string | undefined;
        page?: string | undefined;
        limit?: string | undefined;
        matter_id?: string | undefined;
        court_location?: string | undefined;
        start_date?: string | undefined;
        end_date?: string | undefined;
    };
}>;
export declare const getTodaysCalendarSchema: z.ZodObject<{
    query: z.ZodObject<{
        lawyer_id: z.ZodOptional<z.ZodEffects<z.ZodString, number, string>>;
    }, "strip", z.ZodTypeAny, {
        lawyer_id?: number | undefined;
    }, {
        lawyer_id?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    query: {
        lawyer_id?: number | undefined;
    };
}, {
    query: {
        lawyer_id?: string | undefined;
    };
}>;
export declare const listCourtsSchema: z.ZodObject<{
    query: z.ZodObject<{
        court_level: z.ZodOptional<z.ZodEnum<["District Court", "Circuit Court", "High Court", "Court of Appeal", "Supreme Court"]>>;
        location: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        location?: string | undefined;
        court_level?: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court" | undefined;
    }, {
        location?: string | undefined;
        court_level?: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court" | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    query: {
        location?: string | undefined;
        court_level?: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court" | undefined;
    };
}, {
    query: {
        location?: string | undefined;
        court_level?: "District Court" | "Circuit Court" | "High Court" | "Court of Appeal" | "Supreme Court" | undefined;
    };
}>;
export type CreateCourtCalendarDto = z.infer<typeof createCourtCalendarSchema>['body'];
export type UpdateCourtCalendarDto = z.infer<typeof updateCourtCalendarSchema>['body'];
export type ListCourtCalendarsQuery = z.infer<typeof listCourtCalendarsSchema>['query'];
export interface CourtCalendarResponse {
    id: number;
    matter_id: number;
    matter_number: string | null;
    matter_title: string;
    client_name: string;
    hearing_id: number | null;
    court_type_id: number | null;
    court_level: string;
    court_location: string;
    court_room: string | null;
    judge_name: string | null;
    docket_number: string | null;
    hearing_date: string;
    hearing_time: string | null;
    hearing_type: string;
    duration_minutes: number | null;
    status: string;
    assigned_lawyer_id: number;
    lawyer_name: string;
    notes: string | null;
    postponement_reason: string | null;
    outcome: string | null;
    created_by: number | null;
    created_at: string;
    updated_at: string;
}
export interface CourtTypeResponse {
    id: number;
    court_level: string;
    location: string;
    court_name: string;
    address: string | null;
    contact_phone: string | null;
    contact_email: string | null;
    is_active: boolean;
}
export interface TodaysCalendarItem {
    id: number;
    matter_id: number;
    matter_number: string | null;
    matter_title: string;
    court_level: string;
    court_location: string;
    court_room: string | null;
    judge_name: string | null;
    hearing_date: string;
    hearing_time: string | null;
    hearing_type: string;
    status: string;
    assigned_lawyer_id: number;
    lawyer_name: string;
    client_name: string;
}
//# sourceMappingURL=dto.d.ts.map