import { z } from 'zod';
// ====================
// Request Schemas
// ====================
export const createCourtCalendarSchema = z.object({
    body: z.object({
        matter_id: z.number().int().positive(),
        hearing_id: z.number().int().positive().optional(),
        court_type_id: z.number().int().positive().optional(),
        court_level: z.enum(['District Court', 'Circuit Court', 'High Court', 'Court of Appeal', 'Supreme Court']),
        court_location: z.string().min(2).max(200),
        court_room: z.string().max(50).optional(),
        judge_name: z.string().max(200).optional(),
        docket_number: z.string().max(100).optional(),
        hearing_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/),
        hearing_time: z.string().regex(/^\d{2}:\d{2}(:\d{2})?$/).optional(),
        hearing_type: z.enum(['Hearing', 'Motion', 'Trial', 'Ruling', 'Judgment', 'Mention', 'Case Management', 'Other']).default('Hearing'),
        duration_minutes: z.number().int().positive().optional().default(60),
        assigned_lawyer_id: z.number().int().positive(),
        notes: z.string().optional(),
    }),
});
export const updateCourtCalendarSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
    body: z.object({
        court_type_id: z.number().int().positive().optional(),
        court_level: z.enum(['District Court', 'Circuit Court', 'High Court', 'Court of Appeal', 'Supreme Court']).optional(),
        court_location: z.string().min(2).max(200).optional(),
        court_room: z.string().max(50).optional(),
        judge_name: z.string().max(200).optional(),
        docket_number: z.string().max(100).optional(),
        hearing_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/).optional(),
        hearing_time: z.string().regex(/^\d{2}:\d{2}(:\d{2})?$/).optional(),
        hearing_type: z.enum(['Hearing', 'Motion', 'Trial', 'Ruling', 'Judgment', 'Mention', 'Case Management', 'Other']).optional(),
        duration_minutes: z.number().int().positive().optional(),
        status: z.enum(['Scheduled', 'Confirmed', 'Postponed', 'Completed', 'Cancelled']).optional(),
        assigned_lawyer_id: z.number().int().positive().optional(),
        notes: z.string().optional(),
        postponement_reason: z.string().optional(),
        outcome: z.string().optional(),
    }),
});
export const getCourtCalendarSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
});
export const listCourtCalendarsSchema = z.object({
    query: z.object({
        page: z.string().regex(/^\d+$/).transform(Number).optional().default('1'),
        limit: z.string().regex(/^\d+$/).transform(Number).optional().default('50'),
        matter_id: z.string().regex(/^\d+$/).transform(Number).optional(),
        lawyer_id: z.string().regex(/^\d+$/).transform(Number).optional(),
        court_location: z.string().optional(),
        start_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/).optional(),
        end_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/).optional(),
        status: z.enum(['Scheduled', 'Confirmed', 'Postponed', 'Completed', 'Cancelled']).optional(),
    }),
});
export const getTodaysCalendarSchema = z.object({
    query: z.object({
        lawyer_id: z.string().regex(/^\d+$/).transform(Number).optional(),
    }),
});
export const listCourtsSchema = z.object({
    query: z.object({
        court_level: z.enum(['District Court', 'Circuit Court', 'High Court', 'Court of Appeal', 'Supreme Court']).optional(),
        location: z.string().optional(),
    }),
});
//# sourceMappingURL=dto.js.map