import { CreateCourtCalendarDto, UpdateCourtCalendarDto, CourtCalendarResponse, CourtTypeResponse, TodaysCalendarItem, ListCourtCalendarsQuery } from './dto.js';
export declare class CourtRepository {
    /**
     * Get all court calendars with pagination and filters
     */
    findAll(query: ListCourtCalendarsQuery): Promise<{
        calendars: CourtCalendarResponse[];
        total: number;
    }>;
    /**
     * Find court calendar by ID
     */
    findById(id: number): Promise<CourtCalendarResponse | null>;
    /**
     * Create court calendar entry
     */
    create(data: CreateCourtCalendarDto, userId: number): Promise<number>;
    /**
     * Update court calendar entry
     */
    update(id: number, data: UpdateCourtCalendarDto): Promise<boolean>;
    /**
     * Delete court calendar entry
     */
    delete(id: number): Promise<boolean>;
    /**
     * Get today's calendar (from view)
     */
    getTodaysCalendar(lawyerId?: number): Promise<TodaysCalendarItem[]>;
    /**
     * Check for scheduling clashes (same lawyer, overlapping time)
     */
    checkClashes(lawyerId: number, hearingDate: string, hearingTime: string, durationMinutes: number, excludeId?: number): Promise<CourtCalendarResponse[]>;
    /**
     * Get all court types
     */
    getCourtTypes(courtLevel?: string, location?: string): Promise<CourtTypeResponse[]>;
}
//# sourceMappingURL=repo.d.ts.map