import { CreateDepartmentDto, UpdateDepartmentDto, DepartmentResponse } from './dto.js';
export declare class DepartmentRepository {
    /**
     * Get all departments
     */
    findAll(): Promise<DepartmentResponse[]>;
    /**
     * Get department by ID
     */
    findById(id: number): Promise<DepartmentResponse | null>;
    /**
     * Check if department name exists (excluding specific ID for updates)
     */
    nameExists(name: string, excludeId?: number): Promise<boolean>;
    /**
     * Create department
     */
    create(data: CreateDepartmentDto): Promise<DepartmentResponse>;
    /**
     * Update department
     */
    update(id: number, data: UpdateDepartmentDto): Promise<DepartmentResponse>;
    /**
     * Delete department
     */
    delete(id: number): Promise<void>;
    /**
     * Check if department has associated roles
     */
    hasRoles(id: number): Promise<boolean>;
    /**
     * Log department action to audit log
     */
    logAction(userId: number, departmentId: number, action: 'CREATE' | 'UPDATE' | 'DELETE', meta: Record<string, any>): Promise<void>;
}
//# sourceMappingURL=repo.d.ts.map