import { z } from 'zod';
export declare const createEmployeeSchema: z.ZodObject<{
    body: z.ZodObject<{
        employee_number: z.ZodString;
        first_name: z.ZodString;
        middle_name: z.ZodOptional<z.ZodString>;
        surname: z.ZodString;
        dob: z.ZodString;
        phone: z.ZodString;
        email: z.ZodString;
        address: z.ZodString;
        department_id: z.ZodNumber;
        role_id: z.ZodNumber;
        is_active: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        department_id: number;
        role_id: number;
        employee_number: string;
        first_name: string;
        surname: string;
        dob: string;
        phone: string;
        email: string;
        address: string;
        is_active?: boolean | undefined;
        middle_name?: string | undefined;
    }, {
        department_id: number;
        role_id: number;
        employee_number: string;
        first_name: string;
        surname: string;
        dob: string;
        phone: string;
        email: string;
        address: string;
        is_active?: boolean | undefined;
        middle_name?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    body: {
        department_id: number;
        role_id: number;
        employee_number: string;
        first_name: string;
        surname: string;
        dob: string;
        phone: string;
        email: string;
        address: string;
        is_active?: boolean | undefined;
        middle_name?: string | undefined;
    };
}, {
    body: {
        department_id: number;
        role_id: number;
        employee_number: string;
        first_name: string;
        surname: string;
        dob: string;
        phone: string;
        email: string;
        address: string;
        is_active?: boolean | undefined;
        middle_name?: string | undefined;
    };
}>;
export declare const updateEmployeeSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        id: string;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        employee_number: z.ZodOptional<z.ZodString>;
        first_name: z.ZodOptional<z.ZodString>;
        middle_name: z.ZodOptional<z.ZodString>;
        surname: z.ZodOptional<z.ZodString>;
        dob: z.ZodOptional<z.ZodString>;
        phone: z.ZodOptional<z.ZodString>;
        email: z.ZodOptional<z.ZodString>;
        address: z.ZodOptional<z.ZodString>;
        department_id: z.ZodOptional<z.ZodNumber>;
        role_id: z.ZodOptional<z.ZodNumber>;
        is_active: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        is_active?: boolean | undefined;
        department_id?: number | undefined;
        role_id?: number | undefined;
        employee_number?: string | undefined;
        first_name?: string | undefined;
        middle_name?: string | undefined;
        surname?: string | undefined;
        dob?: string | undefined;
        phone?: string | undefined;
        email?: string | undefined;
        address?: string | undefined;
    }, {
        is_active?: boolean | undefined;
        department_id?: number | undefined;
        role_id?: number | undefined;
        employee_number?: string | undefined;
        first_name?: string | undefined;
        middle_name?: string | undefined;
        surname?: string | undefined;
        dob?: string | undefined;
        phone?: string | undefined;
        email?: string | undefined;
        address?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: string;
    };
    body: {
        is_active?: boolean | undefined;
        department_id?: number | undefined;
        role_id?: number | undefined;
        employee_number?: string | undefined;
        first_name?: string | undefined;
        middle_name?: string | undefined;
        surname?: string | undefined;
        dob?: string | undefined;
        phone?: string | undefined;
        email?: string | undefined;
        address?: string | undefined;
    };
}, {
    params: {
        id: string;
    };
    body: {
        is_active?: boolean | undefined;
        department_id?: number | undefined;
        role_id?: number | undefined;
        employee_number?: string | undefined;
        first_name?: string | undefined;
        middle_name?: string | undefined;
        surname?: string | undefined;
        dob?: string | undefined;
        phone?: string | undefined;
        email?: string | undefined;
        address?: string | undefined;
    };
}>;
export declare const deleteEmployeeSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        id: string;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: string;
    };
}, {
    params: {
        id: string;
    };
}>;
export declare const getEmployeeSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        id: string;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: string;
    };
}, {
    params: {
        id: string;
    };
}>;
export type CreateEmployeeDto = z.infer<typeof createEmployeeSchema>['body'];
export type UpdateEmployeeDto = z.infer<typeof updateEmployeeSchema>['body'];
export interface EmployeeResponse {
    id: number;
    employee_number: string;
    first_name: string;
    middle_name: string | null;
    surname: string;
    dob: string;
    phone: string;
    email: string;
    address: string;
    department_id: number;
    department_name: string;
    role_id: number;
    role_name: string;
    is_active: boolean;
    created_at: Date;
}
//# sourceMappingURL=dto.d.ts.map