import { CreateEmployeeDto, UpdateEmployeeDto, EmployeeResponse } from './dto.js';
export declare class EmployeeRepository {
    /**
     * Get all employees with department and role info
     */
    findAll(): Promise<EmployeeResponse[]>;
    /**
     * Get employee by ID
     */
    findById(id: number): Promise<EmployeeResponse | null>;
    /**
     * Check if email exists (excluding specific ID for updates)
     */
    emailExists(email: string, excludeId?: number): Promise<boolean>;
    /**
     * Check if department exists
     */
    departmentExists(departmentId: number): Promise<boolean>;
    /**
     * Check if role exists and belongs to department
     */
    roleExistsInDepartment(roleId: number, departmentId: number): Promise<boolean>;
    /**
     * Create employee
     */
    create(data: CreateEmployeeDto): Promise<EmployeeResponse>;
    /**
     * Update employee
     */
    update(id: number, data: UpdateEmployeeDto): Promise<EmployeeResponse>;
    /**
     * Delete employee
     */
    delete(id: number): Promise<void>;
    /**
     * Check if employee has associated user
     */
    hasUser(id: number): Promise<boolean>;
    /**
     * Log employee action to audit log
     */
    logAction(userId: number, employeeId: number, action: 'CREATE' | 'UPDATE' | 'DELETE', meta: Record<string, any>): Promise<void>;
}
//# sourceMappingURL=repo.d.ts.map