import { z } from 'zod';
export declare const createEvidenceSchema: z.ZodObject<{
    body: z.ZodObject<{
        matter_id: z.ZodNumber;
        exhibit_label: z.ZodString;
        description: z.ZodString;
        evidence_type: z.ZodEnum<["Document", "Physical Object", "Digital File", "Audio Recording", "Video Recording", "Photograph", "Other"]>;
        file_path: z.ZodOptional<z.ZodString>;
        file_hash: z.ZodOptional<z.ZodString>;
        file_size_bytes: z.ZodOptional<z.ZodNumber>;
        file_mime_type: z.ZodOptional<z.ZodString>;
        collection_date: z.ZodOptional<z.ZodString>;
        collection_location: z.ZodOptional<z.ZodString>;
        collected_by: z.ZodOptional<z.ZodString>;
        storage_location: z.ZodOptional<z.ZodString>;
        is_sealed: z.ZodDefault<z.ZodBoolean>;
        seal_number: z.ZodOptional<z.ZodString>;
        linked_hearing_id: z.ZodOptional<z.ZodNumber>;
        notes: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        description: string;
        matter_id: number;
        exhibit_label: string;
        evidence_type: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph";
        is_sealed: boolean;
        notes?: string | undefined;
        file_path?: string | undefined;
        file_hash?: string | undefined;
        file_size_bytes?: number | undefined;
        file_mime_type?: string | undefined;
        collection_date?: string | undefined;
        collection_location?: string | undefined;
        collected_by?: string | undefined;
        storage_location?: string | undefined;
        seal_number?: string | undefined;
        linked_hearing_id?: number | undefined;
    }, {
        description: string;
        matter_id: number;
        exhibit_label: string;
        evidence_type: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph";
        notes?: string | undefined;
        file_path?: string | undefined;
        file_hash?: string | undefined;
        file_size_bytes?: number | undefined;
        file_mime_type?: string | undefined;
        collection_date?: string | undefined;
        collection_location?: string | undefined;
        collected_by?: string | undefined;
        storage_location?: string | undefined;
        is_sealed?: boolean | undefined;
        seal_number?: string | undefined;
        linked_hearing_id?: number | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    body: {
        description: string;
        matter_id: number;
        exhibit_label: string;
        evidence_type: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph";
        is_sealed: boolean;
        notes?: string | undefined;
        file_path?: string | undefined;
        file_hash?: string | undefined;
        file_size_bytes?: number | undefined;
        file_mime_type?: string | undefined;
        collection_date?: string | undefined;
        collection_location?: string | undefined;
        collected_by?: string | undefined;
        storage_location?: string | undefined;
        seal_number?: string | undefined;
        linked_hearing_id?: number | undefined;
    };
}, {
    body: {
        description: string;
        matter_id: number;
        exhibit_label: string;
        evidence_type: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph";
        notes?: string | undefined;
        file_path?: string | undefined;
        file_hash?: string | undefined;
        file_size_bytes?: number | undefined;
        file_mime_type?: string | undefined;
        collection_date?: string | undefined;
        collection_location?: string | undefined;
        collected_by?: string | undefined;
        storage_location?: string | undefined;
        is_sealed?: boolean | undefined;
        seal_number?: string | undefined;
        linked_hearing_id?: number | undefined;
    };
}>;
export declare const updateEvidenceSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        exhibit_label: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        evidence_type: z.ZodOptional<z.ZodEnum<["Document", "Physical Object", "Digital File", "Audio Recording", "Video Recording", "Photograph", "Other"]>>;
        file_path: z.ZodOptional<z.ZodString>;
        file_hash: z.ZodOptional<z.ZodString>;
        file_size_bytes: z.ZodOptional<z.ZodNumber>;
        file_mime_type: z.ZodOptional<z.ZodString>;
        collection_date: z.ZodOptional<z.ZodString>;
        collection_location: z.ZodOptional<z.ZodString>;
        collected_by: z.ZodOptional<z.ZodString>;
        current_state: z.ZodOptional<z.ZodEnum<["Collected", "Labeled", "Stored", "In Transit", "Presented", "Returned", "Disposed"]>>;
        storage_location: z.ZodOptional<z.ZodString>;
        is_sealed: z.ZodOptional<z.ZodBoolean>;
        seal_number: z.ZodOptional<z.ZodString>;
        linked_hearing_id: z.ZodOptional<z.ZodNumber>;
        notes: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        description?: string | undefined;
        notes?: string | undefined;
        exhibit_label?: string | undefined;
        evidence_type?: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph" | undefined;
        file_path?: string | undefined;
        file_hash?: string | undefined;
        file_size_bytes?: number | undefined;
        file_mime_type?: string | undefined;
        collection_date?: string | undefined;
        collection_location?: string | undefined;
        collected_by?: string | undefined;
        storage_location?: string | undefined;
        is_sealed?: boolean | undefined;
        seal_number?: string | undefined;
        linked_hearing_id?: number | undefined;
        current_state?: "Collected" | "Labeled" | "Stored" | "In Transit" | "Presented" | "Returned" | "Disposed" | undefined;
    }, {
        description?: string | undefined;
        notes?: string | undefined;
        exhibit_label?: string | undefined;
        evidence_type?: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph" | undefined;
        file_path?: string | undefined;
        file_hash?: string | undefined;
        file_size_bytes?: number | undefined;
        file_mime_type?: string | undefined;
        collection_date?: string | undefined;
        collection_location?: string | undefined;
        collected_by?: string | undefined;
        storage_location?: string | undefined;
        is_sealed?: boolean | undefined;
        seal_number?: string | undefined;
        linked_hearing_id?: number | undefined;
        current_state?: "Collected" | "Labeled" | "Stored" | "In Transit" | "Presented" | "Returned" | "Disposed" | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
    body: {
        description?: string | undefined;
        notes?: string | undefined;
        exhibit_label?: string | undefined;
        evidence_type?: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph" | undefined;
        file_path?: string | undefined;
        file_hash?: string | undefined;
        file_size_bytes?: number | undefined;
        file_mime_type?: string | undefined;
        collection_date?: string | undefined;
        collection_location?: string | undefined;
        collected_by?: string | undefined;
        storage_location?: string | undefined;
        is_sealed?: boolean | undefined;
        seal_number?: string | undefined;
        linked_hearing_id?: number | undefined;
        current_state?: "Collected" | "Labeled" | "Stored" | "In Transit" | "Presented" | "Returned" | "Disposed" | undefined;
    };
}, {
    params: {
        id: string;
    };
    body: {
        description?: string | undefined;
        notes?: string | undefined;
        exhibit_label?: string | undefined;
        evidence_type?: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph" | undefined;
        file_path?: string | undefined;
        file_hash?: string | undefined;
        file_size_bytes?: number | undefined;
        file_mime_type?: string | undefined;
        collection_date?: string | undefined;
        collection_location?: string | undefined;
        collected_by?: string | undefined;
        storage_location?: string | undefined;
        is_sealed?: boolean | undefined;
        seal_number?: string | undefined;
        linked_hearing_id?: number | undefined;
        current_state?: "Collected" | "Labeled" | "Stored" | "In Transit" | "Presented" | "Returned" | "Disposed" | undefined;
    };
}>;
export declare const getEvidenceSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
}, {
    params: {
        id: string;
    };
}>;
export declare const listEvidenceSchema: z.ZodObject<{
    query: z.ZodObject<{
        matter_id: z.ZodOptional<z.ZodEffects<z.ZodString, number, string>>;
        evidence_type: z.ZodOptional<z.ZodEnum<["Document", "Physical Object", "Digital File", "Audio Recording", "Video Recording", "Photograph", "Other"]>>;
        current_state: z.ZodOptional<z.ZodEnum<["Collected", "Labeled", "Stored", "In Transit", "Presented", "Returned", "Disposed"]>>;
        search: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        search?: string | undefined;
        matter_id?: number | undefined;
        evidence_type?: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph" | undefined;
        current_state?: "Collected" | "Labeled" | "Stored" | "In Transit" | "Presented" | "Returned" | "Disposed" | undefined;
    }, {
        search?: string | undefined;
        matter_id?: string | undefined;
        evidence_type?: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph" | undefined;
        current_state?: "Collected" | "Labeled" | "Stored" | "In Transit" | "Presented" | "Returned" | "Disposed" | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    query: {
        search?: string | undefined;
        matter_id?: number | undefined;
        evidence_type?: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph" | undefined;
        current_state?: "Collected" | "Labeled" | "Stored" | "In Transit" | "Presented" | "Returned" | "Disposed" | undefined;
    };
}, {
    query: {
        search?: string | undefined;
        matter_id?: string | undefined;
        evidence_type?: "Other" | "Document" | "Physical Object" | "Digital File" | "Audio Recording" | "Video Recording" | "Photograph" | undefined;
        current_state?: "Collected" | "Labeled" | "Stored" | "In Transit" | "Presented" | "Returned" | "Disposed" | undefined;
    };
}>;
export declare const recordCustodyEventSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        event_type: z.ZodEnum<["Collected", "Labeled", "Transferred", "Stored", "Retrieved", "Presented", "Returned", "Disposed", "Photographed", "Examined"]>;
        from_person: z.ZodOptional<z.ZodString>;
        to_person: z.ZodOptional<z.ZodString>;
        location: z.ZodOptional<z.ZodString>;
        purpose: z.ZodOptional<z.ZodString>;
        witness_name: z.ZodOptional<z.ZodString>;
        notes: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        event_type: "Collected" | "Labeled" | "Stored" | "Presented" | "Returned" | "Disposed" | "Transferred" | "Retrieved" | "Photographed" | "Examined";
        location?: string | undefined;
        notes?: string | undefined;
        from_person?: string | undefined;
        to_person?: string | undefined;
        purpose?: string | undefined;
        witness_name?: string | undefined;
    }, {
        event_type: "Collected" | "Labeled" | "Stored" | "Presented" | "Returned" | "Disposed" | "Transferred" | "Retrieved" | "Photographed" | "Examined";
        location?: string | undefined;
        notes?: string | undefined;
        from_person?: string | undefined;
        to_person?: string | undefined;
        purpose?: string | undefined;
        witness_name?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
    body: {
        event_type: "Collected" | "Labeled" | "Stored" | "Presented" | "Returned" | "Disposed" | "Transferred" | "Retrieved" | "Photographed" | "Examined";
        location?: string | undefined;
        notes?: string | undefined;
        from_person?: string | undefined;
        to_person?: string | undefined;
        purpose?: string | undefined;
        witness_name?: string | undefined;
    };
}, {
    params: {
        id: string;
    };
    body: {
        event_type: "Collected" | "Labeled" | "Stored" | "Presented" | "Returned" | "Disposed" | "Transferred" | "Retrieved" | "Photographed" | "Examined";
        location?: string | undefined;
        notes?: string | undefined;
        from_person?: string | undefined;
        to_person?: string | undefined;
        purpose?: string | undefined;
        witness_name?: string | undefined;
    };
}>;
export declare const getCustodyHistorySchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
}, {
    params: {
        id: string;
    };
}>;
export type CreateEvidenceDto = z.infer<typeof createEvidenceSchema>['body'];
export type UpdateEvidenceDto = z.infer<typeof updateEvidenceSchema>['body'];
export type RecordCustodyEventDto = z.infer<typeof recordCustodyEventSchema>['body'];
export interface EvidenceResponse {
    id: number;
    matter_id: number;
    matter_number: string | null;
    matter_title: string;
    exhibit_label: string;
    description: string;
    evidence_type: string;
    file_path: string | null;
    file_hash: string | null;
    file_size_bytes: number | null;
    file_mime_type: string | null;
    collection_date: string | null;
    collection_location: string | null;
    collected_by: string | null;
    current_state: string;
    storage_location: string | null;
    is_sealed: boolean;
    seal_number: string | null;
    linked_hearing_id: number | null;
    notes: string | null;
    created_by: number | null;
    created_at: string;
    updated_at: string;
}
export interface CustodyEventResponse {
    id: number;
    evidence_id: number;
    event_type: string;
    event_date: string;
    from_person: string | null;
    to_person: string | null;
    location: string | null;
    purpose: string | null;
    witness_name: string | null;
    notes: string | null;
    recorded_by: number;
    recorded_by_name: string;
    recorded_at: string;
}
export interface EvidenceWithCustody extends EvidenceResponse {
    custody_events: CustodyEventResponse[];
}
//# sourceMappingURL=dto.d.ts.map