import { z } from 'zod';
// ====================
// Request Schemas
// ====================
export const createEvidenceSchema = z.object({
    body: z.object({
        matter_id: z.number().int().positive(),
        exhibit_label: z.string().min(1).max(50),
        description: z.string().min(5),
        evidence_type: z.enum(['Document', 'Physical Object', 'Digital File', 'Audio Recording', 'Video Recording', 'Photograph', 'Other']),
        file_path: z.string().max(500).optional(),
        file_hash: z.string().max(128).optional(),
        file_size_bytes: z.number().int().positive().optional(),
        file_mime_type: z.string().max(100).optional(),
        collection_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/).optional(),
        collection_location: z.string().max(300).optional(),
        collected_by: z.string().max(200).optional(),
        storage_location: z.string().max(300).optional(),
        is_sealed: z.boolean().default(false),
        seal_number: z.string().max(100).optional(),
        linked_hearing_id: z.number().int().positive().optional(),
        notes: z.string().optional(),
    }),
});
export const updateEvidenceSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
    body: z.object({
        exhibit_label: z.string().min(1).max(50).optional(),
        description: z.string().min(5).optional(),
        evidence_type: z.enum(['Document', 'Physical Object', 'Digital File', 'Audio Recording', 'Video Recording', 'Photograph', 'Other']).optional(),
        file_path: z.string().max(500).optional(),
        file_hash: z.string().max(128).optional(),
        file_size_bytes: z.number().int().positive().optional(),
        file_mime_type: z.string().max(100).optional(),
        collection_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/).optional(),
        collection_location: z.string().max(300).optional(),
        collected_by: z.string().max(200).optional(),
        current_state: z.enum(['Collected', 'Labeled', 'Stored', 'In Transit', 'Presented', 'Returned', 'Disposed']).optional(),
        storage_location: z.string().max(300).optional(),
        is_sealed: z.boolean().optional(),
        seal_number: z.string().max(100).optional(),
        linked_hearing_id: z.number().int().positive().optional(),
        notes: z.string().optional(),
    }),
});
export const getEvidenceSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
});
export const listEvidenceSchema = z.object({
    query: z.object({
        matter_id: z.string().regex(/^\d+$/).transform(Number).optional(),
        evidence_type: z.enum(['Document', 'Physical Object', 'Digital File', 'Audio Recording', 'Video Recording', 'Photograph', 'Other']).optional(),
        current_state: z.enum(['Collected', 'Labeled', 'Stored', 'In Transit', 'Presented', 'Returned', 'Disposed']).optional(),
        search: z.string().optional(),
    }),
});
export const recordCustodyEventSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
    body: z.object({
        event_type: z.enum(['Collected', 'Labeled', 'Transferred', 'Stored', 'Retrieved', 'Presented', 'Returned', 'Disposed', 'Photographed', 'Examined']),
        from_person: z.string().max(200).optional(),
        to_person: z.string().max(200).optional(),
        location: z.string().max(300).optional(),
        purpose: z.string().optional(),
        witness_name: z.string().max(200).optional(),
        notes: z.string().optional(),
    }),
});
export const getCustodyHistorySchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
});
//# sourceMappingURL=dto.js.map