import { CreateEvidenceDto, UpdateEvidenceDto, RecordCustodyEventDto, EvidenceResponse, CustodyEventResponse, EvidenceWithCustody } from './dto.js';
export declare class EvidenceRepository {
    /**
     * Get all evidence items
     */
    findAll(filters: {
        matter_id?: number;
        evidence_type?: string;
        current_state?: string;
        search?: string;
    }): Promise<EvidenceResponse[]>;
    /**
     * Find evidence by ID with custody history
     */
    findById(id: number): Promise<EvidenceWithCustody | null>;
    /**
     * Create evidence item
     */
    create(data: CreateEvidenceDto, userId: number): Promise<number>;
    /**
     * Update evidence item
     */
    update(id: number, data: UpdateEvidenceDto, userId: number): Promise<boolean>;
    /**
     * Delete evidence item
     */
    delete(id: number): Promise<boolean>;
    /**
     * Record custody event (chain-of-custody)
     */
    recordCustodyEvent(evidenceId: number, data: RecordCustodyEventDto, userId: number): Promise<number>;
    /**
     * Get custody history for evidence
     */
    getCustodyHistory(evidenceId: number): Promise<CustodyEventResponse[]>;
}
//# sourceMappingURL=repo.d.ts.map