import { z } from 'zod';
export declare const createExpenseSchema: z.ZodObject<{
    matter_id: z.ZodNumber;
    expense_date: z.ZodString;
    category: z.ZodString;
    amount: z.ZodNumber;
    currency: z.ZodDefault<z.ZodString>;
    description: z.ZodString;
    receipt_path: z.ZodOptional<z.ZodString>;
    receipt_number: z.ZodOptional<z.ZodString>;
    vendor_name: z.ZodOptional<z.ZodString>;
    billable: z.ZodDefault<z.ZodBoolean>;
    markup_percent: z.ZodDefault<z.ZodNumber>;
    reimbursable: z.ZodDefault<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    description: string;
    matter_id: number;
    billable: boolean;
    expense_date: string;
    category: string;
    amount: number;
    currency: string;
    markup_percent: number;
    reimbursable: boolean;
    receipt_path?: string | undefined;
    receipt_number?: string | undefined;
    vendor_name?: string | undefined;
}, {
    description: string;
    matter_id: number;
    expense_date: string;
    category: string;
    amount: number;
    billable?: boolean | undefined;
    currency?: string | undefined;
    receipt_path?: string | undefined;
    receipt_number?: string | undefined;
    vendor_name?: string | undefined;
    markup_percent?: number | undefined;
    reimbursable?: boolean | undefined;
}>;
export type CreateExpenseDto = z.infer<typeof createExpenseSchema>;
export declare const updateExpenseSchema: z.ZodObject<{
    expense_date: z.ZodOptional<z.ZodString>;
    category: z.ZodOptional<z.ZodString>;
    amount: z.ZodOptional<z.ZodNumber>;
    description: z.ZodOptional<z.ZodString>;
    receipt_path: z.ZodOptional<z.ZodString>;
    receipt_number: z.ZodOptional<z.ZodString>;
    vendor_name: z.ZodOptional<z.ZodString>;
    billable: z.ZodOptional<z.ZodBoolean>;
    markup_percent: z.ZodOptional<z.ZodNumber>;
    reimbursable: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    description?: string | undefined;
    billable?: boolean | undefined;
    expense_date?: string | undefined;
    category?: string | undefined;
    amount?: number | undefined;
    receipt_path?: string | undefined;
    receipt_number?: string | undefined;
    vendor_name?: string | undefined;
    markup_percent?: number | undefined;
    reimbursable?: boolean | undefined;
}, {
    description?: string | undefined;
    billable?: boolean | undefined;
    expense_date?: string | undefined;
    category?: string | undefined;
    amount?: number | undefined;
    receipt_path?: string | undefined;
    receipt_number?: string | undefined;
    vendor_name?: string | undefined;
    markup_percent?: number | undefined;
    reimbursable?: boolean | undefined;
}>;
export type UpdateExpenseDto = z.infer<typeof updateExpenseSchema>;
export declare const queryExpensesSchema: z.ZodObject<{
    page: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    limit: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    user_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    matter_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    category: z.ZodOptional<z.ZodString>;
    status: z.ZodOptional<z.ZodEnum<["Draft", "Submitted", "Approved", "Rejected", "Invoiced", "Reimbursed"]>>;
    start_date: z.ZodOptional<z.ZodString>;
    end_date: z.ZodOptional<z.ZodString>;
    billable: z.ZodEffects<z.ZodOptional<z.ZodString>, boolean | undefined, string | undefined>;
    reimbursable: z.ZodEffects<z.ZodOptional<z.ZodString>, boolean | undefined, string | undefined>;
}, "strip", z.ZodTypeAny, {
    page: number;
    limit: number;
    status?: "Draft" | "Submitted" | "Approved" | "Rejected" | "Invoiced" | "Reimbursed" | undefined;
    user_id?: number | undefined;
    matter_id?: number | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    billable?: boolean | undefined;
    category?: string | undefined;
    reimbursable?: boolean | undefined;
}, {
    status?: "Draft" | "Submitted" | "Approved" | "Rejected" | "Invoiced" | "Reimbursed" | undefined;
    user_id?: string | undefined;
    page?: string | undefined;
    limit?: string | undefined;
    matter_id?: string | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    billable?: string | undefined;
    category?: string | undefined;
    reimbursable?: string | undefined;
}>;
export type QueryExpensesDto = z.infer<typeof queryExpensesSchema>;
export declare const submitExpenseSchema: z.ZodObject<{
    expense_ids: z.ZodArray<z.ZodNumber, "many">;
}, "strip", z.ZodTypeAny, {
    expense_ids: number[];
}, {
    expense_ids: number[];
}>;
export type SubmitExpenseDto = z.infer<typeof submitExpenseSchema>;
export declare const approveExpenseSchema: z.ZodObject<{
    expense_ids: z.ZodArray<z.ZodNumber, "many">;
}, "strip", z.ZodTypeAny, {
    expense_ids: number[];
}, {
    expense_ids: number[];
}>;
export type ApproveExpenseDto = z.infer<typeof approveExpenseSchema>;
export declare const rejectExpenseSchema: z.ZodObject<{
    expense_ids: z.ZodArray<z.ZodNumber, "many">;
    rejection_reason: z.ZodString;
}, "strip", z.ZodTypeAny, {
    rejection_reason: string;
    expense_ids: number[];
}, {
    rejection_reason: string;
    expense_ids: number[];
}>;
export type RejectExpenseDto = z.infer<typeof rejectExpenseSchema>;
export declare const createExpenseCategorySchema: z.ZodObject<{
    category_name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    default_billable: z.ZodDefault<z.ZodBoolean>;
    default_markup_percent: z.ZodDefault<z.ZodNumber>;
    sort_order: z.ZodDefault<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    default_billable: boolean;
    sort_order: number;
    category_name: string;
    default_markup_percent: number;
    description?: string | undefined;
}, {
    category_name: string;
    description?: string | undefined;
    default_billable?: boolean | undefined;
    sort_order?: number | undefined;
    default_markup_percent?: number | undefined;
}>;
export type CreateExpenseCategoryDto = z.infer<typeof createExpenseCategorySchema>;
export declare const updateExpenseCategorySchema: z.ZodObject<{
    category_name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    default_billable: z.ZodOptional<z.ZodBoolean>;
    default_markup_percent: z.ZodOptional<z.ZodNumber>;
    is_active: z.ZodOptional<z.ZodBoolean>;
    sort_order: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    is_active?: boolean | undefined;
    description?: string | undefined;
    default_billable?: boolean | undefined;
    sort_order?: number | undefined;
    category_name?: string | undefined;
    default_markup_percent?: number | undefined;
}, {
    is_active?: boolean | undefined;
    description?: string | undefined;
    default_billable?: boolean | undefined;
    sort_order?: number | undefined;
    category_name?: string | undefined;
    default_markup_percent?: number | undefined;
}>;
export type UpdateExpenseCategoryDto = z.infer<typeof updateExpenseCategorySchema>;
export interface ExpenseResponse {
    id: number;
    matter_id: number;
    matter_number: string | null;
    matter_title: string;
    user_id: number;
    user_name: string;
    expense_date: string;
    category: string;
    amount: number;
    currency: string;
    description: string;
    receipt_path: string | null;
    receipt_number: string | null;
    vendor_name: string | null;
    billable: boolean;
    markup_percent: number;
    billable_amount: number | null;
    reimbursable: boolean;
    status: 'Draft' | 'Submitted' | 'Approved' | 'Rejected' | 'Invoiced' | 'Reimbursed';
    submitted_at: string | null;
    approved_by: number | null;
    approved_by_name: string | null;
    approved_at: string | null;
    rejection_reason: string | null;
    created_at: string;
    updated_at: string;
}
export interface ExpenseCategoryResponse {
    id: number;
    category_name: string;
    description: string | null;
    default_billable: boolean;
    default_markup_percent: number;
    is_active: boolean;
    sort_order: number;
    created_at: string;
    updated_at: string;
}
//# sourceMappingURL=dto.d.ts.map