import type { CreateExpenseDto, UpdateExpenseDto, QueryExpensesDto, CreateExpenseCategoryDto, UpdateExpenseCategoryDto, ExpenseResponse, ExpenseCategoryResponse } from './dto.js';
export declare class ExpenseRepository {
    listExpenses(query: QueryExpensesDto, currentUserId: number, canViewAll: boolean): Promise<{
        expenses: ExpenseResponse[];
        pagination: {
            page: number;
            limit: number;
            total: any;
            totalPages: number;
        };
    }>;
    getExpenseById(id: number, currentUserId: number, canViewAll: boolean): Promise<ExpenseResponse | null>;
    createExpense(data: CreateExpenseDto, userId: number): Promise<ExpenseResponse | null>;
    updateExpense(id: number, data: UpdateExpenseDto, userId: number, canViewAll: boolean): Promise<ExpenseResponse | null>;
    deleteExpense(id: number, userId: number, canViewAll: boolean): Promise<void>;
    submitExpenses(expenseIds: number[], userId: number): Promise<void>;
    approveExpenses(expenseIds: number[], approverId: number): Promise<void>;
    rejectExpenses(expenseIds: number[], approverId: number, reason: string): Promise<void>;
    listExpenseCategories(activeOnly?: boolean): Promise<ExpenseCategoryResponse[]>;
    getExpenseCategoryById(id: number): Promise<ExpenseCategoryResponse | null>;
    createExpenseCategory(data: CreateExpenseCategoryDto): Promise<ExpenseCategoryResponse | null>;
    updateExpenseCategory(id: number, data: UpdateExpenseCategoryDto): Promise<ExpenseCategoryResponse | null>;
}
export declare const expenseRepo: ExpenseRepository;
//# sourceMappingURL=repo.d.ts.map