import { z } from 'zod';
export declare const createFeeArrangementSchema: z.ZodObject<{
    matter_id: z.ZodNumber;
    fee_type: z.ZodEnum<["Hourly", "Fixed", "Capped", "Contingency", "Blended", "Custom"]>;
    base_hourly_rate: z.ZodOptional<z.ZodNumber>;
    fixed_amount: z.ZodOptional<z.ZodNumber>;
    cap_amount: z.ZodOptional<z.ZodNumber>;
    contingency_percent: z.ZodOptional<z.ZodNumber>;
    billing_frequency: z.ZodDefault<z.ZodEnum<["Weekly", "Bi-weekly", "Monthly", "Milestone", "On Completion"]>>;
    payment_terms_days: z.ZodDefault<z.ZodNumber>;
    description: z.ZodOptional<z.ZodString>;
    terms_document_path: z.ZodOptional<z.ZodString>;
    effective_date: z.ZodString;
    end_date: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    matter_id: number;
    fee_type: "Hourly" | "Fixed" | "Capped" | "Contingency" | "Blended" | "Custom";
    billing_frequency: "Weekly" | "Bi-weekly" | "Monthly" | "Milestone" | "On Completion";
    payment_terms_days: number;
    effective_date: string;
    description?: string | undefined;
    end_date?: string | undefined;
    base_hourly_rate?: number | undefined;
    fixed_amount?: number | undefined;
    cap_amount?: number | undefined;
    contingency_percent?: number | undefined;
    terms_document_path?: string | undefined;
}, {
    matter_id: number;
    fee_type: "Hourly" | "Fixed" | "Capped" | "Contingency" | "Blended" | "Custom";
    effective_date: string;
    description?: string | undefined;
    end_date?: string | undefined;
    base_hourly_rate?: number | undefined;
    fixed_amount?: number | undefined;
    cap_amount?: number | undefined;
    contingency_percent?: number | undefined;
    billing_frequency?: "Weekly" | "Bi-weekly" | "Monthly" | "Milestone" | "On Completion" | undefined;
    payment_terms_days?: number | undefined;
    terms_document_path?: string | undefined;
}>;
export type CreateFeeArrangementDto = z.infer<typeof createFeeArrangementSchema>;
export declare const updateFeeArrangementSchema: z.ZodObject<{
    fee_type: z.ZodOptional<z.ZodEnum<["Hourly", "Fixed", "Capped", "Contingency", "Blended", "Custom"]>>;
    base_hourly_rate: z.ZodOptional<z.ZodNumber>;
    fixed_amount: z.ZodOptional<z.ZodNumber>;
    cap_amount: z.ZodOptional<z.ZodNumber>;
    contingency_percent: z.ZodOptional<z.ZodNumber>;
    billing_frequency: z.ZodOptional<z.ZodEnum<["Weekly", "Bi-weekly", "Monthly", "Milestone", "On Completion"]>>;
    payment_terms_days: z.ZodOptional<z.ZodNumber>;
    description: z.ZodOptional<z.ZodString>;
    terms_document_path: z.ZodOptional<z.ZodString>;
    end_date: z.ZodOptional<z.ZodString>;
    is_active: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    is_active?: boolean | undefined;
    description?: string | undefined;
    end_date?: string | undefined;
    fee_type?: "Hourly" | "Fixed" | "Capped" | "Contingency" | "Blended" | "Custom" | undefined;
    base_hourly_rate?: number | undefined;
    fixed_amount?: number | undefined;
    cap_amount?: number | undefined;
    contingency_percent?: number | undefined;
    billing_frequency?: "Weekly" | "Bi-weekly" | "Monthly" | "Milestone" | "On Completion" | undefined;
    payment_terms_days?: number | undefined;
    terms_document_path?: string | undefined;
}, {
    is_active?: boolean | undefined;
    description?: string | undefined;
    end_date?: string | undefined;
    fee_type?: "Hourly" | "Fixed" | "Capped" | "Contingency" | "Blended" | "Custom" | undefined;
    base_hourly_rate?: number | undefined;
    fixed_amount?: number | undefined;
    cap_amount?: number | undefined;
    contingency_percent?: number | undefined;
    billing_frequency?: "Weekly" | "Bi-weekly" | "Monthly" | "Milestone" | "On Completion" | undefined;
    payment_terms_days?: number | undefined;
    terms_document_path?: string | undefined;
}>;
export type UpdateFeeArrangementDto = z.infer<typeof updateFeeArrangementSchema>;
export declare const createRateCardSchema: z.ZodObject<{
    user_id: z.ZodOptional<z.ZodNumber>;
    role_id: z.ZodOptional<z.ZodNumber>;
    practice_area: z.ZodOptional<z.ZodString>;
    client_id: z.ZodOptional<z.ZodNumber>;
    hourly_rate: z.ZodNumber;
    currency: z.ZodDefault<z.ZodString>;
    effective_date: z.ZodString;
    end_date: z.ZodOptional<z.ZodString>;
    is_default: z.ZodDefault<z.ZodBoolean>;
    notes: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    is_default: boolean;
    hourly_rate: number;
    currency: string;
    effective_date: string;
    user_id?: number | undefined;
    role_id?: number | undefined;
    client_id?: number | undefined;
    notes?: string | undefined;
    end_date?: string | undefined;
    practice_area?: string | undefined;
}, {
    hourly_rate: number;
    effective_date: string;
    user_id?: number | undefined;
    role_id?: number | undefined;
    client_id?: number | undefined;
    is_default?: boolean | undefined;
    notes?: string | undefined;
    end_date?: string | undefined;
    currency?: string | undefined;
    practice_area?: string | undefined;
}>;
export type CreateRateCardDto = z.infer<typeof createRateCardSchema>;
export declare const updateRateCardSchema: z.ZodObject<{
    hourly_rate: z.ZodOptional<z.ZodNumber>;
    end_date: z.ZodOptional<z.ZodString>;
    is_default: z.ZodOptional<z.ZodBoolean>;
    notes: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    is_default?: boolean | undefined;
    notes?: string | undefined;
    end_date?: string | undefined;
    hourly_rate?: number | undefined;
}, {
    is_default?: boolean | undefined;
    notes?: string | undefined;
    end_date?: string | undefined;
    hourly_rate?: number | undefined;
}>;
export type UpdateRateCardDto = z.infer<typeof updateRateCardSchema>;
export declare const queryRateCardsSchema: z.ZodObject<{
    user_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    role_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    practice_area: z.ZodOptional<z.ZodString>;
    client_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    is_default: z.ZodEffects<z.ZodOptional<z.ZodString>, boolean | undefined, string | undefined>;
}, "strip", z.ZodTypeAny, {
    user_id?: number | undefined;
    role_id?: number | undefined;
    client_id?: number | undefined;
    is_default?: boolean | undefined;
    practice_area?: string | undefined;
}, {
    user_id?: string | undefined;
    role_id?: string | undefined;
    client_id?: string | undefined;
    is_default?: string | undefined;
    practice_area?: string | undefined;
}>;
export type QueryRateCardsDto = z.infer<typeof queryRateCardsSchema>;
export interface FeeArrangementResponse {
    id: number;
    matter_id: number;
    matter_number: string | null;
    matter_title: string;
    fee_type: 'Hourly' | 'Fixed' | 'Capped' | 'Contingency' | 'Blended' | 'Custom';
    base_hourly_rate: number | null;
    fixed_amount: number | null;
    cap_amount: number | null;
    contingency_percent: number | null;
    billing_frequency: 'Weekly' | 'Bi-weekly' | 'Monthly' | 'Milestone' | 'On Completion';
    payment_terms_days: number;
    description: string | null;
    terms_document_path: string | null;
    effective_date: string;
    end_date: string | null;
    is_active: boolean;
    created_by: number;
    created_by_name: string;
    created_at: string;
    updated_at: string;
}
export interface RateCardResponse {
    id: number;
    user_id: number | null;
    user_name: string | null;
    role_id: number | null;
    role_name: string | null;
    practice_area: string | null;
    client_id: number | null;
    client_name: string | null;
    hourly_rate: number;
    currency: string;
    effective_date: string;
    end_date: string | null;
    is_default: boolean;
    notes: string | null;
    created_by: number;
    created_by_name: string;
    created_at: string;
    updated_at: string;
}
//# sourceMappingURL=dto.d.ts.map