import { z } from 'zod';
// ================================================
// Fee Arrangement DTOs
// ================================================
// Create Fee Arrangement
export const createFeeArrangementSchema = z.object({
    matter_id: z.number().int().positive(),
    fee_type: z.enum(['Hourly', 'Fixed', 'Capped', 'Contingency', 'Blended', 'Custom']),
    base_hourly_rate: z.number().positive().optional(),
    fixed_amount: z.number().positive().optional(),
    cap_amount: z.number().positive().optional(),
    contingency_percent: z.number().min(0).max(100).optional(),
    billing_frequency: z.enum(['Weekly', 'Bi-weekly', 'Monthly', 'Milestone', 'On Completion']).default('Monthly'),
    payment_terms_days: z.number().int().positive().default(30),
    description: z.string().max(5000).optional(),
    terms_document_path: z.string().max(500).optional(),
    effective_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/),
    end_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/).optional(),
});
// Update Fee Arrangement
export const updateFeeArrangementSchema = z.object({
    fee_type: z.enum(['Hourly', 'Fixed', 'Capped', 'Contingency', 'Blended', 'Custom']).optional(),
    base_hourly_rate: z.number().positive().optional(),
    fixed_amount: z.number().positive().optional(),
    cap_amount: z.number().positive().optional(),
    contingency_percent: z.number().min(0).max(100).optional(),
    billing_frequency: z.enum(['Weekly', 'Bi-weekly', 'Monthly', 'Milestone', 'On Completion']).optional(),
    payment_terms_days: z.number().int().positive().optional(),
    description: z.string().max(5000).optional(),
    terms_document_path: z.string().max(500).optional(),
    end_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/).optional(),
    is_active: z.boolean().optional(),
});
// ================================================
// Rate Card DTOs
// ================================================
// Create Rate Card
export const createRateCardSchema = z.object({
    user_id: z.number().int().positive().optional(),
    role_id: z.number().int().positive().optional(),
    practice_area: z.string().max(100).optional(),
    client_id: z.number().int().positive().optional(),
    hourly_rate: z.number().positive(),
    currency: z.string().length(3).default('GHS'),
    effective_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/),
    end_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/).optional(),
    is_default: z.boolean().default(false),
    notes: z.string().max(1000).optional(),
});
// Update Rate Card
export const updateRateCardSchema = z.object({
    hourly_rate: z.number().positive().optional(),
    end_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/).optional(),
    is_default: z.boolean().optional(),
    notes: z.string().max(1000).optional(),
});
// Query Parameters
export const queryRateCardsSchema = z.object({
    user_id: z.string().optional().transform(val => val ? parseInt(val) : undefined),
    role_id: z.string().optional().transform(val => val ? parseInt(val) : undefined),
    practice_area: z.string().optional(),
    client_id: z.string().optional().transform(val => val ? parseInt(val) : undefined),
    is_default: z.string().optional().transform(val => val === 'true' ? true : val === 'false' ? false : undefined),
});
//# sourceMappingURL=dto.js.map