import type { CreateFeeArrangementDto, UpdateFeeArrangementDto, CreateRateCardDto, UpdateRateCardDto, QueryRateCardsDto, FeeArrangementResponse, RateCardResponse } from './dto.js';
export declare class FeeRepository {
    getFeeArrangementByMatter(matterId: number): Promise<FeeArrangementResponse | null>;
    getFeeArrangementById(id: number): Promise<FeeArrangementResponse | null>;
    listFeeArrangements(matterId?: number): Promise<FeeArrangementResponse[]>;
    createFeeArrangement(data: CreateFeeArrangementDto, userId: number): Promise<FeeArrangementResponse | null>;
    updateFeeArrangement(id: number, data: UpdateFeeArrangementDto): Promise<FeeArrangementResponse | null>;
    deleteFeeArrangement(id: number): Promise<void>;
    listRateCards(query: QueryRateCardsDto): Promise<RateCardResponse[]>;
    getRateCardById(id: number): Promise<RateCardResponse | null>;
    createRateCard(data: CreateRateCardDto, userId: number): Promise<RateCardResponse | null>;
    updateRateCard(id: number, data: UpdateRateCardDto): Promise<RateCardResponse | null>;
    deleteRateCard(id: number): Promise<void>;
    getApplicableRate(userId: number, matterId: number): Promise<number | null>;
}
export declare const feeRepo: FeeRepository;
//# sourceMappingURL=repo.d.ts.map