import { z } from 'zod';
export declare const createInvoiceLineItemSchema: z.ZodObject<{
    item_type: z.ZodEnum<["Time", "Expense", "Fee", "Adjustment"]>;
    time_entry_id: z.ZodOptional<z.ZodNumber>;
    expense_id: z.ZodOptional<z.ZodNumber>;
    description: z.ZodString;
    quantity: z.ZodDefault<z.ZodNumber>;
    unit_price: z.ZodNumber;
    amount: z.ZodNumber;
    is_taxable: z.ZodDefault<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    description: string;
    amount: number;
    item_type: "Time" | "Expense" | "Fee" | "Adjustment";
    quantity: number;
    unit_price: number;
    is_taxable: boolean;
    time_entry_id?: number | undefined;
    expense_id?: number | undefined;
}, {
    description: string;
    amount: number;
    item_type: "Time" | "Expense" | "Fee" | "Adjustment";
    unit_price: number;
    time_entry_id?: number | undefined;
    expense_id?: number | undefined;
    quantity?: number | undefined;
    is_taxable?: boolean | undefined;
}>;
export type CreateInvoiceLineItemDto = z.infer<typeof createInvoiceLineItemSchema>;
export declare const createInvoiceSchema: z.ZodObject<{
    matter_id: z.ZodNumber;
    client_id: z.ZodNumber;
    invoice_date: z.ZodString;
    due_date: z.ZodString;
    time_entry_ids: z.ZodOptional<z.ZodArray<z.ZodNumber, "many">>;
    expense_ids: z.ZodOptional<z.ZodArray<z.ZodNumber, "many">>;
    line_items: z.ZodOptional<z.ZodArray<z.ZodObject<{
        item_type: z.ZodEnum<["Time", "Expense", "Fee", "Adjustment"]>;
        time_entry_id: z.ZodOptional<z.ZodNumber>;
        expense_id: z.ZodOptional<z.ZodNumber>;
        description: z.ZodString;
        quantity: z.ZodDefault<z.ZodNumber>;
        unit_price: z.ZodNumber;
        amount: z.ZodNumber;
        is_taxable: z.ZodDefault<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        description: string;
        amount: number;
        item_type: "Time" | "Expense" | "Fee" | "Adjustment";
        quantity: number;
        unit_price: number;
        is_taxable: boolean;
        time_entry_id?: number | undefined;
        expense_id?: number | undefined;
    }, {
        description: string;
        amount: number;
        item_type: "Time" | "Expense" | "Fee" | "Adjustment";
        unit_price: number;
        time_entry_id?: number | undefined;
        expense_id?: number | undefined;
        quantity?: number | undefined;
        is_taxable?: boolean | undefined;
    }>, "many">>;
    notes: z.ZodOptional<z.ZodString>;
    payment_instructions: z.ZodOptional<z.ZodString>;
    apply_vat: z.ZodDefault<z.ZodBoolean>;
    apply_nhil: z.ZodDefault<z.ZodBoolean>;
    apply_getfund: z.ZodDefault<z.ZodBoolean>;
    apply_wht: z.ZodDefault<z.ZodBoolean>;
    wht_rate: z.ZodDefault<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    client_id: number;
    matter_id: number;
    invoice_date: string;
    due_date: string;
    apply_vat: boolean;
    apply_nhil: boolean;
    apply_getfund: boolean;
    apply_wht: boolean;
    wht_rate: number;
    notes?: string | undefined;
    expense_ids?: number[] | undefined;
    time_entry_ids?: number[] | undefined;
    line_items?: {
        description: string;
        amount: number;
        item_type: "Time" | "Expense" | "Fee" | "Adjustment";
        quantity: number;
        unit_price: number;
        is_taxable: boolean;
        time_entry_id?: number | undefined;
        expense_id?: number | undefined;
    }[] | undefined;
    payment_instructions?: string | undefined;
}, {
    client_id: number;
    matter_id: number;
    invoice_date: string;
    due_date: string;
    notes?: string | undefined;
    expense_ids?: number[] | undefined;
    time_entry_ids?: number[] | undefined;
    line_items?: {
        description: string;
        amount: number;
        item_type: "Time" | "Expense" | "Fee" | "Adjustment";
        unit_price: number;
        time_entry_id?: number | undefined;
        expense_id?: number | undefined;
        quantity?: number | undefined;
        is_taxable?: boolean | undefined;
    }[] | undefined;
    payment_instructions?: string | undefined;
    apply_vat?: boolean | undefined;
    apply_nhil?: boolean | undefined;
    apply_getfund?: boolean | undefined;
    apply_wht?: boolean | undefined;
    wht_rate?: number | undefined;
}>;
export type CreateInvoiceDto = z.infer<typeof createInvoiceSchema>;
export declare const updateInvoiceSchema: z.ZodObject<{
    invoice_date: z.ZodOptional<z.ZodString>;
    due_date: z.ZodOptional<z.ZodString>;
    notes: z.ZodOptional<z.ZodString>;
    payment_instructions: z.ZodOptional<z.ZodString>;
    status: z.ZodOptional<z.ZodEnum<["Draft", "Sent", "Paid", "Partially Paid", "Overdue", "Cancelled"]>>;
}, "strip", z.ZodTypeAny, {
    status?: "Cancelled" | "Draft" | "Sent" | "Paid" | "Partially Paid" | "Overdue" | undefined;
    notes?: string | undefined;
    invoice_date?: string | undefined;
    due_date?: string | undefined;
    payment_instructions?: string | undefined;
}, {
    status?: "Cancelled" | "Draft" | "Sent" | "Paid" | "Partially Paid" | "Overdue" | undefined;
    notes?: string | undefined;
    invoice_date?: string | undefined;
    due_date?: string | undefined;
    payment_instructions?: string | undefined;
}>;
export type UpdateInvoiceDto = z.infer<typeof updateInvoiceSchema>;
export declare const queryInvoicesSchema: z.ZodObject<{
    page: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    limit: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    matter_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    client_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    status: z.ZodOptional<z.ZodEnum<["Draft", "Sent", "Paid", "Partially Paid", "Overdue", "Cancelled"]>>;
    start_date: z.ZodOptional<z.ZodString>;
    end_date: z.ZodOptional<z.ZodString>;
    overdue_only: z.ZodEffects<z.ZodOptional<z.ZodString>, boolean, string | undefined>;
}, "strip", z.ZodTypeAny, {
    page: number;
    limit: number;
    overdue_only: boolean;
    status?: "Cancelled" | "Draft" | "Sent" | "Paid" | "Partially Paid" | "Overdue" | undefined;
    client_id?: number | undefined;
    matter_id?: number | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
}, {
    status?: "Cancelled" | "Draft" | "Sent" | "Paid" | "Partially Paid" | "Overdue" | undefined;
    client_id?: string | undefined;
    page?: string | undefined;
    limit?: string | undefined;
    matter_id?: string | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    overdue_only?: string | undefined;
}>;
export type QueryInvoicesDto = z.infer<typeof queryInvoicesSchema>;
export declare const sendInvoiceSchema: z.ZodObject<{
    send_email: z.ZodDefault<z.ZodBoolean>;
    email_message: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    send_email: boolean;
    email_message?: string | undefined;
}, {
    send_email?: boolean | undefined;
    email_message?: string | undefined;
}>;
export type SendInvoiceDto = z.infer<typeof sendInvoiceSchema>;
export declare const recordPaymentSchema: z.ZodObject<{
    amount: z.ZodNumber;
    payment_date: z.ZodString;
    payment_method: z.ZodOptional<z.ZodString>;
    reference_number: z.ZodOptional<z.ZodString>;
    notes: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    amount: number;
    payment_date: string;
    notes?: string | undefined;
    payment_method?: string | undefined;
    reference_number?: string | undefined;
}, {
    amount: number;
    payment_date: string;
    notes?: string | undefined;
    payment_method?: string | undefined;
    reference_number?: string | undefined;
}>;
export type RecordPaymentDto = z.infer<typeof recordPaymentSchema>;
export interface InvoiceLineItemResponse {
    id: number;
    invoice_id: number;
    item_type: 'Time' | 'Expense' | 'Fee' | 'Adjustment';
    time_entry_id: number | null;
    expense_id: number | null;
    description: string;
    quantity: number;
    unit_price: number;
    amount: number;
    is_taxable: boolean;
    created_at: string;
}
export interface InvoiceResponse {
    id: number;
    invoice_number: string;
    matter_id: number;
    matter_number: string | null;
    matter_title: string;
    client_id: number;
    client_name: string;
    client_email: string | null;
    invoice_date: string;
    due_date: string;
    subtotal: number;
    vat_amount: number;
    nhil_amount: number;
    getfund_amount: number;
    total_before_wht: number;
    wht_amount: number;
    total_amount: number;
    amount_paid: number;
    balance_due: number;
    status: 'Draft' | 'Sent' | 'Paid' | 'Partially Paid' | 'Overdue' | 'Cancelled';
    notes: string | null;
    payment_instructions: string | null;
    sent_at: string | null;
    sent_by: number | null;
    sent_by_name: string | null;
    created_by: number;
    created_by_name: string;
    created_at: string;
    updated_at: string;
    line_items?: InvoiceLineItemResponse[];
}
export interface InvoiceSummaryResponse {
    total_invoices: number;
    total_amount: number;
    total_paid: number;
    total_outstanding: number;
    draft_count: number;
    sent_count: number;
    overdue_count: number;
    paid_count: number;
}
export interface PaymentRecordResponse {
    id: number;
    invoice_id: number;
    invoice_number: string;
    amount: number;
    payment_date: string;
    payment_method: string | null;
    reference_number: string | null;
    notes: string | null;
    recorded_by: number;
    recorded_by_name: string;
    created_at: string;
}
//# sourceMappingURL=dto.d.ts.map