import type { CreateInvoiceDto, UpdateInvoiceDto, QueryInvoicesDto, RecordPaymentDto, InvoiceResponse, InvoiceLineItemResponse, InvoiceSummaryResponse, PaymentRecordResponse } from './dto.js';
export declare class InvoiceRepository {
    listInvoices(query: QueryInvoicesDto): Promise<{
        invoices: InvoiceResponse[];
        pagination: {
            page: number;
            limit: number;
            total: any;
            totalPages: number;
        };
    }>;
    getInvoiceById(id: number, includeLineItems?: boolean): Promise<InvoiceResponse | null>;
    getInvoiceLineItems(invoiceId: number): Promise<InvoiceLineItemResponse[]>;
    generateInvoiceNumber(year: number): Promise<string>;
    createInvoice(data: CreateInvoiceDto, userId: number): Promise<InvoiceResponse | null>;
    updateInvoice(id: number, data: UpdateInvoiceDto): Promise<InvoiceResponse | null>;
    sendInvoice(id: number, userId: number): Promise<InvoiceResponse | null>;
    recordPayment(invoiceId: number, data: RecordPaymentDto, userId: number): Promise<PaymentRecordResponse | null>;
    getInvoiceSummary(clientId?: number, matterId?: number): Promise<InvoiceSummaryResponse>;
    cancelInvoice(id: number): Promise<void>;
}
export declare const invoiceRepo: InvoiceRepository;
//# sourceMappingURL=repo.d.ts.map