import { z } from 'zod';
export declare const createMatterSchema: z.ZodObject<{
    body: z.ZodObject<{
        case_number: z.ZodOptional<z.ZodString>;
        case_type: z.ZodEnum<["Civil", "Criminal", "Corporate", "Family", "Property", "Labour"]>;
        title: z.ZodString;
        description: z.ZodOptional<z.ZodString>;
        client_id: z.ZodNumber;
        lawyer_id: z.ZodNumber;
        filing_date: z.ZodString;
        location: z.ZodOptional<z.ZodString>;
        latitude: z.ZodOptional<z.ZodNumber>;
        longitude: z.ZodOptional<z.ZodNumber>;
        workflow_id: z.ZodOptional<z.ZodNumber>;
        parties: z.ZodOptional<z.ZodArray<z.ZodObject<{
            party_type: z.ZodEnum<["Client", "Related Party", "Adverse Party", "Counsel", "Other"]>;
            name: z.ZodString;
            identifier: z.ZodOptional<z.ZodString>;
            relationship: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            party_type: "Client" | "Related Party" | "Adverse Party" | "Counsel" | "Other";
            identifier?: string | undefined;
            relationship?: string | undefined;
        }, {
            name: string;
            party_type: "Client" | "Related Party" | "Adverse Party" | "Counsel" | "Other";
            identifier?: string | undefined;
            relationship?: string | undefined;
        }>, "many">>;
    }, "strip", z.ZodTypeAny, {
        case_type: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour";
        title: string;
        client_id: number;
        lawyer_id: number;
        filing_date: string;
        description?: string | undefined;
        case_number?: string | undefined;
        location?: string | undefined;
        latitude?: number | undefined;
        longitude?: number | undefined;
        workflow_id?: number | undefined;
        parties?: {
            name: string;
            party_type: "Client" | "Related Party" | "Adverse Party" | "Counsel" | "Other";
            identifier?: string | undefined;
            relationship?: string | undefined;
        }[] | undefined;
    }, {
        case_type: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour";
        title: string;
        client_id: number;
        lawyer_id: number;
        filing_date: string;
        description?: string | undefined;
        case_number?: string | undefined;
        location?: string | undefined;
        latitude?: number | undefined;
        longitude?: number | undefined;
        workflow_id?: number | undefined;
        parties?: {
            name: string;
            party_type: "Client" | "Related Party" | "Adverse Party" | "Counsel" | "Other";
            identifier?: string | undefined;
            relationship?: string | undefined;
        }[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    body: {
        case_type: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour";
        title: string;
        client_id: number;
        lawyer_id: number;
        filing_date: string;
        description?: string | undefined;
        case_number?: string | undefined;
        location?: string | undefined;
        latitude?: number | undefined;
        longitude?: number | undefined;
        workflow_id?: number | undefined;
        parties?: {
            name: string;
            party_type: "Client" | "Related Party" | "Adverse Party" | "Counsel" | "Other";
            identifier?: string | undefined;
            relationship?: string | undefined;
        }[] | undefined;
    };
}, {
    body: {
        case_type: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour";
        title: string;
        client_id: number;
        lawyer_id: number;
        filing_date: string;
        description?: string | undefined;
        case_number?: string | undefined;
        location?: string | undefined;
        latitude?: number | undefined;
        longitude?: number | undefined;
        workflow_id?: number | undefined;
        parties?: {
            name: string;
            party_type: "Client" | "Related Party" | "Adverse Party" | "Counsel" | "Other";
            identifier?: string | undefined;
            relationship?: string | undefined;
        }[] | undefined;
    };
}>;
export declare const updateMatterSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        case_number: z.ZodOptional<z.ZodString>;
        case_type: z.ZodOptional<z.ZodEnum<["Civil", "Criminal", "Corporate", "Family", "Property", "Labour"]>>;
        case_status: z.ZodOptional<z.ZodEnum<["Active", "Pending", "Closed", "Won", "Lost"]>>;
        title: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        client_id: z.ZodOptional<z.ZodNumber>;
        lawyer_id: z.ZodOptional<z.ZodNumber>;
        location: z.ZodOptional<z.ZodString>;
        latitude: z.ZodOptional<z.ZodNumber>;
        longitude: z.ZodOptional<z.ZodNumber>;
        workflow_id: z.ZodOptional<z.ZodNumber>;
        current_stage: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        description?: string | undefined;
        case_number?: string | undefined;
        case_type?: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour" | undefined;
        title?: string | undefined;
        client_id?: number | undefined;
        lawyer_id?: number | undefined;
        location?: string | undefined;
        latitude?: number | undefined;
        longitude?: number | undefined;
        workflow_id?: number | undefined;
        case_status?: "Active" | "Pending" | "Closed" | "Won" | "Lost" | undefined;
        current_stage?: string | undefined;
    }, {
        description?: string | undefined;
        case_number?: string | undefined;
        case_type?: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour" | undefined;
        title?: string | undefined;
        client_id?: number | undefined;
        lawyer_id?: number | undefined;
        location?: string | undefined;
        latitude?: number | undefined;
        longitude?: number | undefined;
        workflow_id?: number | undefined;
        case_status?: "Active" | "Pending" | "Closed" | "Won" | "Lost" | undefined;
        current_stage?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
    body: {
        description?: string | undefined;
        case_number?: string | undefined;
        case_type?: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour" | undefined;
        title?: string | undefined;
        client_id?: number | undefined;
        lawyer_id?: number | undefined;
        location?: string | undefined;
        latitude?: number | undefined;
        longitude?: number | undefined;
        workflow_id?: number | undefined;
        case_status?: "Active" | "Pending" | "Closed" | "Won" | "Lost" | undefined;
        current_stage?: string | undefined;
    };
}, {
    params: {
        id: string;
    };
    body: {
        description?: string | undefined;
        case_number?: string | undefined;
        case_type?: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour" | undefined;
        title?: string | undefined;
        client_id?: number | undefined;
        lawyer_id?: number | undefined;
        location?: string | undefined;
        latitude?: number | undefined;
        longitude?: number | undefined;
        workflow_id?: number | undefined;
        case_status?: "Active" | "Pending" | "Closed" | "Won" | "Lost" | undefined;
        current_stage?: string | undefined;
    };
}>;
export declare const getMatterSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
}, {
    params: {
        id: string;
    };
}>;
export declare const deleteMatterSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
}, {
    params: {
        id: string;
    };
}>;
export declare const addPartySchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        party_type: z.ZodEnum<["Client", "Related Party", "Adverse Party", "Counsel", "Other"]>;
        name: z.ZodString;
        identifier: z.ZodOptional<z.ZodString>;
        relationship: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        party_type: "Client" | "Related Party" | "Adverse Party" | "Counsel" | "Other";
        identifier?: string | undefined;
        relationship?: string | undefined;
    }, {
        name: string;
        party_type: "Client" | "Related Party" | "Adverse Party" | "Counsel" | "Other";
        identifier?: string | undefined;
        relationship?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
    body: {
        name: string;
        party_type: "Client" | "Related Party" | "Adverse Party" | "Counsel" | "Other";
        identifier?: string | undefined;
        relationship?: string | undefined;
    };
}, {
    params: {
        id: string;
    };
    body: {
        name: string;
        party_type: "Client" | "Related Party" | "Adverse Party" | "Counsel" | "Other";
        identifier?: string | undefined;
        relationship?: string | undefined;
    };
}>;
export declare const listMattersSchema: z.ZodObject<{
    query: z.ZodObject<{
        page: z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodString, number, string>>>;
        limit: z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodString, number, string>>>;
        case_type: z.ZodOptional<z.ZodEnum<["Civil", "Criminal", "Corporate", "Family", "Property", "Labour"]>>;
        case_status: z.ZodOptional<z.ZodEnum<["Active", "Pending", "Closed", "Won", "Lost"]>>;
        client_id: z.ZodOptional<z.ZodEffects<z.ZodString, number, string>>;
        lawyer_id: z.ZodOptional<z.ZodEffects<z.ZodString, number, string>>;
        search: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        page: number;
        limit: number;
        search?: string | undefined;
        case_type?: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour" | undefined;
        client_id?: number | undefined;
        lawyer_id?: number | undefined;
        case_status?: "Active" | "Pending" | "Closed" | "Won" | "Lost" | undefined;
    }, {
        search?: string | undefined;
        case_type?: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour" | undefined;
        client_id?: string | undefined;
        lawyer_id?: string | undefined;
        case_status?: "Active" | "Pending" | "Closed" | "Won" | "Lost" | undefined;
        page?: string | undefined;
        limit?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    query: {
        page: number;
        limit: number;
        search?: string | undefined;
        case_type?: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour" | undefined;
        client_id?: number | undefined;
        lawyer_id?: number | undefined;
        case_status?: "Active" | "Pending" | "Closed" | "Won" | "Lost" | undefined;
    };
}, {
    query: {
        search?: string | undefined;
        case_type?: "Civil" | "Criminal" | "Corporate" | "Family" | "Property" | "Labour" | undefined;
        client_id?: string | undefined;
        lawyer_id?: string | undefined;
        case_status?: "Active" | "Pending" | "Closed" | "Won" | "Lost" | undefined;
        page?: string | undefined;
        limit?: string | undefined;
    };
}>;
export type CreateMatterDto = z.infer<typeof createMatterSchema>['body'];
export type UpdateMatterDto = z.infer<typeof updateMatterSchema>['body'];
export type AddPartyDto = z.infer<typeof addPartySchema>['body'];
export type ListMattersQuery = z.infer<typeof listMattersSchema>['query'];
export interface MatterResponse {
    id: number;
    matter_id: string | null;
    case_number: string;
    case_type: string;
    case_status: string;
    title: string;
    description: string | null;
    client_id: number;
    client_name: string;
    lawyer_id: number;
    lawyer_name: string;
    filing_date: string;
    closing_date: string | null;
    location: string | null;
    latitude: number | null;
    longitude: number | null;
    workflow_id: number | null;
    workflow_name: string | null;
    current_stage: string | null;
    is_active: boolean;
    created_at: string;
    updated_at: string;
}
export interface ConflictPartyResponse {
    id: number;
    matter_id: number;
    party_type: string;
    name: string;
    identifier: string | null;
    relationship: string | null;
    created_at: string;
}
export interface MatterWithParties extends MatterResponse {
    parties: ConflictPartyResponse[];
}
//# sourceMappingURL=dto.d.ts.map