import { z } from 'zod';
// ====================
// Request Schemas
// ====================
export const createMatterSchema = z.object({
    body: z.object({
        case_number: z.string().optional(),
        case_type: z.enum(['Civil', 'Criminal', 'Corporate', 'Family', 'Property', 'Labour']),
        title: z.string().min(5, 'Title must be at least 5 characters').max(200),
        description: z.string().optional(),
        client_id: z.number().int().positive(),
        lawyer_id: z.number().int().positive(),
        filing_date: z.string().regex(/^\d{4}-\d{2}-\d{2}$/, 'Invalid date format (YYYY-MM-DD)'),
        location: z.string().optional(),
        latitude: z.number().optional(),
        longitude: z.number().optional(),
        workflow_id: z.number().int().positive().optional(),
        // Conflict parties
        parties: z.array(z.object({
            party_type: z.enum(['Client', 'Related Party', 'Adverse Party', 'Counsel', 'Other']),
            name: z.string().min(2).max(200),
            identifier: z.string().max(100).optional(),
            relationship: z.string().max(200).optional(),
        })).optional(),
    }),
});
export const updateMatterSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
    body: z.object({
        case_number: z.string().optional(),
        case_type: z.enum(['Civil', 'Criminal', 'Corporate', 'Family', 'Property', 'Labour']).optional(),
        case_status: z.enum(['Active', 'Pending', 'Closed', 'Won', 'Lost']).optional(),
        title: z.string().min(5).max(200).optional(),
        description: z.string().optional(),
        client_id: z.number().int().positive().optional(),
        lawyer_id: z.number().int().positive().optional(),
        location: z.string().optional(),
        latitude: z.number().optional(),
        longitude: z.number().optional(),
        workflow_id: z.number().int().positive().optional(),
        current_stage: z.string().max(100).optional(),
    }),
});
export const getMatterSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
});
export const deleteMatterSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
});
export const addPartySchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
    body: z.object({
        party_type: z.enum(['Client', 'Related Party', 'Adverse Party', 'Counsel', 'Other']),
        name: z.string().min(2, 'Name must be at least 2 characters').max(200),
        identifier: z.string().max(100).optional(),
        relationship: z.string().max(200).optional(),
    }),
});
export const listMattersSchema = z.object({
    query: z.object({
        page: z.string().regex(/^\d+$/).transform(Number).optional().default('1'),
        limit: z.string().regex(/^\d+$/).transform(Number).optional().default('20'),
        case_type: z.enum(['Civil', 'Criminal', 'Corporate', 'Family', 'Property', 'Labour']).optional(),
        case_status: z.enum(['Active', 'Pending', 'Closed', 'Won', 'Lost']).optional(),
        client_id: z.string().regex(/^\d+$/).transform(Number).optional(),
        lawyer_id: z.string().regex(/^\d+$/).transform(Number).optional(),
        search: z.string().optional(), // Search by matter_id, case_number, or title
    }),
});
//# sourceMappingURL=dto.js.map