import { CreateMatterDto, UpdateMatterDto, AddPartyDto, MatterResponse, ConflictPartyResponse, MatterWithParties, ListMattersQuery } from './dto.js';
export declare class MatterRepository {
    /**
     * Get all matters with client and lawyer info (paginated)
     */
    findAll(query: ListMattersQuery): Promise<{
        matters: MatterResponse[];
        total: number;
    }>;
    /**
     * Find matter by ID with full details
     */
    findById(id: number): Promise<MatterWithParties | null>;
    /**
     * Create a new matter
     */
    create(data: CreateMatterDto, matter_id: string): Promise<number>;
    /**
     * Update matter
     */
    update(id: number, data: UpdateMatterDto): Promise<boolean>;
    /**
     * Soft delete matter
     */
    delete(id: number): Promise<boolean>;
    /**
     * Add party to matter for conflict tracking
     */
    addParty(matter_id: number, data: AddPartyDto): Promise<number>;
    /**
     * Get parties by matter ID
     */
    getPartiesByMatterId(matter_id: number): Promise<ConflictPartyResponse[]>;
    /**
     * Get next sequence number for matter ID generation
     */
    getNextSequence(): Promise<{
        current: number;
        config: any;
    }>;
}
//# sourceMappingURL=repo.d.ts.map