import { z } from 'zod';
export declare const paymentAllocationSchema: z.ZodObject<{
    invoice_id: z.ZodNumber;
    amount: z.ZodNumber;
}, "strip", z.ZodTypeAny, {
    amount: number;
    invoice_id: number;
}, {
    amount: number;
    invoice_id: number;
}>;
export type PaymentAllocationDto = z.infer<typeof paymentAllocationSchema>;
export declare const createReceiptSchema: z.ZodObject<{
    client_id: z.ZodNumber;
    receipt_date: z.ZodString;
    amount: z.ZodNumber;
    payment_method: z.ZodEnum<["Cash", "Cheque", "Bank Transfer", "Mobile Money", "Card", "Other"]>;
    reference_number: z.ZodOptional<z.ZodString>;
    bank_name: z.ZodOptional<z.ZodString>;
    cheque_number: z.ZodOptional<z.ZodString>;
    notes: z.ZodOptional<z.ZodString>;
    allocations: z.ZodArray<z.ZodObject<{
        invoice_id: z.ZodNumber;
        amount: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        amount: number;
        invoice_id: number;
    }, {
        amount: number;
        invoice_id: number;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    client_id: number;
    amount: number;
    payment_method: "Other" | "Cash" | "Cheque" | "Bank Transfer" | "Mobile Money" | "Card";
    receipt_date: string;
    allocations: {
        amount: number;
        invoice_id: number;
    }[];
    notes?: string | undefined;
    reference_number?: string | undefined;
    bank_name?: string | undefined;
    cheque_number?: string | undefined;
}, {
    client_id: number;
    amount: number;
    payment_method: "Other" | "Cash" | "Cheque" | "Bank Transfer" | "Mobile Money" | "Card";
    receipt_date: string;
    allocations: {
        amount: number;
        invoice_id: number;
    }[];
    notes?: string | undefined;
    reference_number?: string | undefined;
    bank_name?: string | undefined;
    cheque_number?: string | undefined;
}>;
export type CreateReceiptDto = z.infer<typeof createReceiptSchema>;
export declare const updateReceiptSchema: z.ZodObject<{
    receipt_date: z.ZodOptional<z.ZodString>;
    payment_method: z.ZodOptional<z.ZodEnum<["Cash", "Cheque", "Bank Transfer", "Mobile Money", "Card", "Other"]>>;
    reference_number: z.ZodOptional<z.ZodString>;
    bank_name: z.ZodOptional<z.ZodString>;
    cheque_number: z.ZodOptional<z.ZodString>;
    notes: z.ZodOptional<z.ZodString>;
    status: z.ZodOptional<z.ZodEnum<["Pending", "Cleared", "Bounced", "Cancelled"]>>;
}, "strip", z.ZodTypeAny, {
    status?: "Pending" | "Cancelled" | "Cleared" | "Bounced" | undefined;
    notes?: string | undefined;
    payment_method?: "Other" | "Cash" | "Cheque" | "Bank Transfer" | "Mobile Money" | "Card" | undefined;
    reference_number?: string | undefined;
    receipt_date?: string | undefined;
    bank_name?: string | undefined;
    cheque_number?: string | undefined;
}, {
    status?: "Pending" | "Cancelled" | "Cleared" | "Bounced" | undefined;
    notes?: string | undefined;
    payment_method?: "Other" | "Cash" | "Cheque" | "Bank Transfer" | "Mobile Money" | "Card" | undefined;
    reference_number?: string | undefined;
    receipt_date?: string | undefined;
    bank_name?: string | undefined;
    cheque_number?: string | undefined;
}>;
export type UpdateReceiptDto = z.infer<typeof updateReceiptSchema>;
export declare const queryReceiptsSchema: z.ZodObject<{
    page: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    limit: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    client_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    payment_method: z.ZodOptional<z.ZodEnum<["Cash", "Cheque", "Bank Transfer", "Mobile Money", "Card", "Other"]>>;
    status: z.ZodOptional<z.ZodEnum<["Pending", "Cleared", "Bounced", "Cancelled"]>>;
    start_date: z.ZodOptional<z.ZodString>;
    end_date: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    page: number;
    limit: number;
    status?: "Pending" | "Cancelled" | "Cleared" | "Bounced" | undefined;
    client_id?: number | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    payment_method?: "Other" | "Cash" | "Cheque" | "Bank Transfer" | "Mobile Money" | "Card" | undefined;
}, {
    status?: "Pending" | "Cancelled" | "Cleared" | "Bounced" | undefined;
    client_id?: string | undefined;
    page?: string | undefined;
    limit?: string | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    payment_method?: "Other" | "Cash" | "Cheque" | "Bank Transfer" | "Mobile Money" | "Card" | undefined;
}>;
export type QueryReceiptsDto = z.infer<typeof queryReceiptsSchema>;
export declare const createCollectionActivitySchema: z.ZodObject<{
    client_id: z.ZodNumber;
    invoice_id: z.ZodOptional<z.ZodNumber>;
    activity_type: z.ZodEnum<["Email", "Phone", "Letter", "Meeting", "Legal Action", "Other"]>;
    activity_date: z.ZodString;
    contact_person: z.ZodOptional<z.ZodString>;
    notes: z.ZodString;
    outcome: z.ZodOptional<z.ZodString>;
    follow_up_date: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    client_id: number;
    notes: string;
    activity_type: "Other" | "Email" | "Phone" | "Letter" | "Meeting" | "Legal Action";
    activity_date: string;
    outcome?: string | undefined;
    invoice_id?: number | undefined;
    contact_person?: string | undefined;
    follow_up_date?: string | undefined;
}, {
    client_id: number;
    notes: string;
    activity_type: "Other" | "Email" | "Phone" | "Letter" | "Meeting" | "Legal Action";
    activity_date: string;
    outcome?: string | undefined;
    invoice_id?: number | undefined;
    contact_person?: string | undefined;
    follow_up_date?: string | undefined;
}>;
export type CreateCollectionActivityDto = z.infer<typeof createCollectionActivitySchema>;
export declare const updateCollectionActivitySchema: z.ZodObject<{
    activity_type: z.ZodOptional<z.ZodEnum<["Email", "Phone", "Letter", "Meeting", "Legal Action", "Other"]>>;
    activity_date: z.ZodOptional<z.ZodString>;
    contact_person: z.ZodOptional<z.ZodString>;
    notes: z.ZodOptional<z.ZodString>;
    outcome: z.ZodOptional<z.ZodString>;
    follow_up_date: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    notes?: string | undefined;
    outcome?: string | undefined;
    activity_type?: "Other" | "Email" | "Phone" | "Letter" | "Meeting" | "Legal Action" | undefined;
    activity_date?: string | undefined;
    contact_person?: string | undefined;
    follow_up_date?: string | undefined;
}, {
    notes?: string | undefined;
    outcome?: string | undefined;
    activity_type?: "Other" | "Email" | "Phone" | "Letter" | "Meeting" | "Legal Action" | undefined;
    activity_date?: string | undefined;
    contact_person?: string | undefined;
    follow_up_date?: string | undefined;
}>;
export type UpdateCollectionActivityDto = z.infer<typeof updateCollectionActivitySchema>;
export declare const queryCollectionActivitiesSchema: z.ZodObject<{
    page: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    limit: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    client_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    invoice_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    activity_type: z.ZodOptional<z.ZodEnum<["Email", "Phone", "Letter", "Meeting", "Legal Action", "Other"]>>;
    start_date: z.ZodOptional<z.ZodString>;
    end_date: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    page: number;
    limit: number;
    client_id?: number | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    invoice_id?: number | undefined;
    activity_type?: "Other" | "Email" | "Phone" | "Letter" | "Meeting" | "Legal Action" | undefined;
}, {
    client_id?: string | undefined;
    page?: string | undefined;
    limit?: string | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    invoice_id?: string | undefined;
    activity_type?: "Other" | "Email" | "Phone" | "Letter" | "Meeting" | "Legal Action" | undefined;
}>;
export type QueryCollectionActivitiesDto = z.infer<typeof queryCollectionActivitiesSchema>;
export interface ReceiptResponse {
    id: number;
    receipt_number: string;
    client_id: number;
    client_name: string;
    receipt_date: string;
    amount: number;
    payment_method: 'Cash' | 'Cheque' | 'Bank Transfer' | 'Mobile Money' | 'Card' | 'Other';
    reference_number: string | null;
    bank_name: string | null;
    cheque_number: string | null;
    notes: string | null;
    status: 'Pending' | 'Cleared' | 'Bounced' | 'Cancelled';
    recorded_by: number;
    recorded_by_name: string;
    created_at: string;
    updated_at: string;
    allocations?: PaymentAllocationResponse[];
}
export interface PaymentAllocationResponse {
    id: number;
    receipt_id: number;
    invoice_id: number;
    invoice_number: string;
    amount: number;
    created_at: string;
}
export interface CollectionActivityResponse {
    id: number;
    client_id: number;
    client_name: string;
    invoice_id: number | null;
    invoice_number: string | null;
    activity_type: 'Email' | 'Phone' | 'Letter' | 'Meeting' | 'Legal Action' | 'Other';
    activity_date: string;
    contact_person: string | null;
    notes: string;
    outcome: string | null;
    follow_up_date: string | null;
    recorded_by: number;
    recorded_by_name: string;
    created_at: string;
    updated_at: string;
}
export interface ReceiptSummaryResponse {
    total_receipts: number;
    total_amount: number;
    pending_clearance: number;
    cleared_amount: number;
    bounced_count: number;
    by_payment_method: {
        payment_method: string;
        count: number;
        amount: number;
    }[];
}
export interface CollectionSummaryResponse {
    total_activities: number;
    activities_this_month: number;
    pending_follow_ups: number;
    by_activity_type: {
        activity_type: string;
        count: number;
    }[];
}
//# sourceMappingURL=dto.d.ts.map