import type { CreateReceiptDto, UpdateReceiptDto, QueryReceiptsDto, CreateCollectionActivityDto, UpdateCollectionActivityDto, QueryCollectionActivitiesDto, ReceiptResponse, PaymentAllocationResponse, CollectionActivityResponse, ReceiptSummaryResponse, CollectionSummaryResponse } from './dto.js';
export declare class ReceiptRepository {
    listReceipts(query: QueryReceiptsDto): Promise<{
        receipts: ReceiptResponse[];
        pagination: {
            page: number;
            limit: number;
            total: any;
            totalPages: number;
        };
    }>;
    getReceiptById(id: number, includeAllocations?: boolean): Promise<ReceiptResponse | null>;
    getReceiptAllocations(receiptId: number): Promise<PaymentAllocationResponse[]>;
    generateReceiptNumber(year: number): Promise<string>;
    createReceipt(data: CreateReceiptDto, userId: number): Promise<ReceiptResponse | null>;
    updateReceipt(id: number, data: UpdateReceiptDto): Promise<ReceiptResponse | null>;
    getReceiptSummary(clientId?: number): Promise<ReceiptSummaryResponse>;
    listCollectionActivities(query: QueryCollectionActivitiesDto): Promise<{
        activities: CollectionActivityResponse[];
        pagination: {
            page: number;
            limit: number;
            total: any;
            totalPages: number;
        };
    }>;
    getCollectionActivityById(id: number): Promise<CollectionActivityResponse | null>;
    createCollectionActivity(data: CreateCollectionActivityDto, userId: number): Promise<CollectionActivityResponse | null>;
    updateCollectionActivity(id: number, data: UpdateCollectionActivityDto): Promise<CollectionActivityResponse | null>;
    getCollectionSummary(clientId?: number): Promise<CollectionSummaryResponse>;
}
export declare const receiptRepo: ReceiptRepository;
//# sourceMappingURL=repo.d.ts.map