import { z } from 'zod';
export declare const createRoleSchema: z.ZodObject<{
    body: z.ZodObject<{
        name: z.ZodString;
        department_id: z.ZodNumber;
        description: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        department_id: number;
        name: string;
        description?: string | undefined;
    }, {
        department_id: number;
        name: string;
        description?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    body: {
        department_id: number;
        name: string;
        description?: string | undefined;
    };
}, {
    body: {
        department_id: number;
        name: string;
        description?: string | undefined;
    };
}>;
export declare const updateRoleSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        id: string;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        name: z.ZodOptional<z.ZodString>;
        department_id: z.ZodOptional<z.ZodNumber>;
        description: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        department_id?: number | undefined;
        name?: string | undefined;
        description?: string | undefined;
    }, {
        department_id?: number | undefined;
        name?: string | undefined;
        description?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: string;
    };
    body: {
        department_id?: number | undefined;
        name?: string | undefined;
        description?: string | undefined;
    };
}, {
    params: {
        id: string;
    };
    body: {
        department_id?: number | undefined;
        name?: string | undefined;
        description?: string | undefined;
    };
}>;
export declare const deleteRoleSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        id: string;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: string;
    };
}, {
    params: {
        id: string;
    };
}>;
export declare const getRoleSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        id: string;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: string;
    };
}, {
    params: {
        id: string;
    };
}>;
export type CreateRoleDto = z.infer<typeof createRoleSchema>['body'];
export type UpdateRoleDto = z.infer<typeof updateRoleSchema>['body'];
export interface RoleResponse {
    id: number;
    name: string;
    department_id: number;
    department_name: string;
    description: string | null;
    created_at: Date;
}
//# sourceMappingURL=dto.d.ts.map