import { z } from 'zod';
// Create role DTO
export const createRoleSchema = z.object({
    body: z.object({
        name: z.string().min(1, 'Role name is required').max(100, 'Name too long'),
        department_id: z.number().int().positive('Department ID is required'),
        description: z.string().optional(),
    }),
});
// Update role DTO
export const updateRoleSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/, 'Invalid role ID'),
    }),
    body: z.object({
        name: z.string().min(1, 'Role name is required').max(100, 'Name too long').optional(),
        department_id: z.number().int().positive('Department ID is required').optional(),
        description: z.string().optional(),
    }),
});
// Delete role DTO
export const deleteRoleSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/, 'Invalid role ID'),
    }),
});
// Get role DTO
export const getRoleSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/, 'Invalid role ID'),
    }),
});
//# sourceMappingURL=dto.js.map