import { CreateRoleDto, UpdateRoleDto, RoleResponse } from './dto.js';
export declare class RoleRepository {
    /**
     * Get all roles with department info
     */
    findAll(departmentId?: number): Promise<RoleResponse[]>;
    /**
     * Get role by ID
     */
    findById(id: number): Promise<RoleResponse | null>;
    /**
     * Check if role name exists in department (excluding specific ID for updates)
     */
    nameExistsInDepartment(name: string, departmentId: number, excludeId?: number): Promise<boolean>;
    /**
     * Check if department exists
     */
    departmentExists(departmentId: number): Promise<boolean>;
    /**
     * Create role
     */
    create(data: CreateRoleDto): Promise<RoleResponse>;
    /**
     * Update role
     */
    update(id: number, data: UpdateRoleDto): Promise<RoleResponse>;
    /**
     * Delete role
     */
    delete(id: number): Promise<void>;
    /**
     * Check if role has associated users
     */
    hasUsers(id: number): Promise<boolean>;
    /**
     * Log role action to audit log
     */
    logAction(userId: number, roleId: number, action: 'CREATE' | 'UPDATE' | 'DELETE', meta: Record<string, any>): Promise<void>;
}
//# sourceMappingURL=repo.d.ts.map