import { z } from 'zod';
export declare const createTimeEntrySchema: z.ZodObject<{
    matter_id: z.ZodNumber;
    task_id: z.ZodOptional<z.ZodNumber>;
    entry_date: z.ZodString;
    hours: z.ZodNumber;
    activity_code: z.ZodString;
    description: z.ZodString;
    billable: z.ZodDefault<z.ZodBoolean>;
    hourly_rate: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    description: string;
    matter_id: number;
    hours: number;
    entry_date: string;
    activity_code: string;
    billable: boolean;
    task_id?: number | undefined;
    hourly_rate?: number | undefined;
}, {
    description: string;
    matter_id: number;
    hours: number;
    entry_date: string;
    activity_code: string;
    task_id?: number | undefined;
    billable?: boolean | undefined;
    hourly_rate?: number | undefined;
}>;
export type CreateTimeEntryDto = z.infer<typeof createTimeEntrySchema>;
export declare const updateTimeEntrySchema: z.ZodObject<{
    entry_date: z.ZodOptional<z.ZodString>;
    hours: z.ZodOptional<z.ZodNumber>;
    activity_code: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    billable: z.ZodOptional<z.ZodBoolean>;
    hourly_rate: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    description?: string | undefined;
    hours?: number | undefined;
    entry_date?: string | undefined;
    activity_code?: string | undefined;
    billable?: boolean | undefined;
    hourly_rate?: number | undefined;
}, {
    description?: string | undefined;
    hours?: number | undefined;
    entry_date?: string | undefined;
    activity_code?: string | undefined;
    billable?: boolean | undefined;
    hourly_rate?: number | undefined;
}>;
export type UpdateTimeEntryDto = z.infer<typeof updateTimeEntrySchema>;
export declare const queryTimeEntriesSchema: z.ZodObject<{
    page: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    limit: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    user_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    matter_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    status: z.ZodOptional<z.ZodEnum<["Draft", "Submitted", "Approved", "Rejected", "Invoiced"]>>;
    start_date: z.ZodOptional<z.ZodString>;
    end_date: z.ZodOptional<z.ZodString>;
    billable: z.ZodEffects<z.ZodOptional<z.ZodString>, boolean | undefined, string | undefined>;
}, "strip", z.ZodTypeAny, {
    page: number;
    limit: number;
    status?: "Draft" | "Submitted" | "Approved" | "Rejected" | "Invoiced" | undefined;
    user_id?: number | undefined;
    matter_id?: number | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    billable?: boolean | undefined;
}, {
    status?: "Draft" | "Submitted" | "Approved" | "Rejected" | "Invoiced" | undefined;
    user_id?: string | undefined;
    page?: string | undefined;
    limit?: string | undefined;
    matter_id?: string | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    billable?: string | undefined;
}>;
export type QueryTimeEntriesDto = z.infer<typeof queryTimeEntriesSchema>;
export declare const submitTimeEntrySchema: z.ZodObject<{
    entry_ids: z.ZodArray<z.ZodNumber, "many">;
}, "strip", z.ZodTypeAny, {
    entry_ids: number[];
}, {
    entry_ids: number[];
}>;
export type SubmitTimeEntryDto = z.infer<typeof submitTimeEntrySchema>;
export declare const approveTimeEntrySchema: z.ZodObject<{
    entry_ids: z.ZodArray<z.ZodNumber, "many">;
}, "strip", z.ZodTypeAny, {
    entry_ids: number[];
}, {
    entry_ids: number[];
}>;
export type ApproveTimeEntryDto = z.infer<typeof approveTimeEntrySchema>;
export declare const rejectTimeEntrySchema: z.ZodObject<{
    entry_ids: z.ZodArray<z.ZodNumber, "many">;
    rejection_reason: z.ZodString;
}, "strip", z.ZodTypeAny, {
    entry_ids: number[];
    rejection_reason: string;
}, {
    entry_ids: number[];
    rejection_reason: string;
}>;
export type RejectTimeEntryDto = z.infer<typeof rejectTimeEntrySchema>;
export declare const startTimerSchema: z.ZodObject<{
    matter_id: z.ZodNumber;
    activity_code: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    matter_id: number;
    activity_code: string;
    description?: string | undefined;
}, {
    matter_id: number;
    activity_code: string;
    description?: string | undefined;
}>;
export type StartTimerDto = z.infer<typeof startTimerSchema>;
export declare const createActivityCodeSchema: z.ZodObject<{
    code: z.ZodString;
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    default_billable: z.ZodDefault<z.ZodBoolean>;
    sort_order: z.ZodDefault<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    code: string;
    name: string;
    default_billable: boolean;
    sort_order: number;
    description?: string | undefined;
}, {
    code: string;
    name: string;
    description?: string | undefined;
    default_billable?: boolean | undefined;
    sort_order?: number | undefined;
}>;
export type CreateActivityCodeDto = z.infer<typeof createActivityCodeSchema>;
export declare const updateActivityCodeSchema: z.ZodObject<{
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    default_billable: z.ZodOptional<z.ZodBoolean>;
    is_active: z.ZodOptional<z.ZodBoolean>;
    sort_order: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    is_active?: boolean | undefined;
    name?: string | undefined;
    description?: string | undefined;
    default_billable?: boolean | undefined;
    sort_order?: number | undefined;
}, {
    is_active?: boolean | undefined;
    name?: string | undefined;
    description?: string | undefined;
    default_billable?: boolean | undefined;
    sort_order?: number | undefined;
}>;
export type UpdateActivityCodeDto = z.infer<typeof updateActivityCodeSchema>;
export interface TimeEntryResponse {
    id: number;
    user_id: number;
    user_name: string;
    matter_id: number;
    matter_number: string | null;
    matter_title: string;
    task_id: number | null;
    entry_date: string;
    start_time: string | null;
    end_time: string | null;
    hours: number;
    activity_code: string;
    activity_name: string;
    description: string;
    billable: boolean;
    hourly_rate: number | null;
    total_amount: number | null;
    status: 'Draft' | 'Submitted' | 'Approved' | 'Rejected' | 'Invoiced';
    submitted_at: string | null;
    approved_by: number | null;
    approved_by_name: string | null;
    approved_at: string | null;
    rejection_reason: string | null;
    created_at: string;
    updated_at: string;
}
export interface RunningTimerResponse {
    id: number;
    user_id: number;
    matter_id: number;
    matter_number: string | null;
    matter_title: string;
    activity_code: string;
    activity_name: string;
    description: string | null;
    start_time: string;
    elapsed_seconds: number;
    elapsed_formatted: string;
}
export interface ActivityCodeResponse {
    id: number;
    code: string;
    name: string;
    description: string | null;
    default_billable: boolean;
    is_active: boolean;
    sort_order: number;
    created_at: string;
    updated_at: string;
}
//# sourceMappingURL=dto.d.ts.map