import type { CreateTimeEntryDto, UpdateTimeEntryDto, QueryTimeEntriesDto, StartTimerDto, CreateActivityCodeDto, UpdateActivityCodeDto, TimeEntryResponse, RunningTimerResponse, ActivityCodeResponse } from './dto.js';
export declare class TimeRepository {
    listTimeEntries(query: QueryTimeEntriesDto, currentUserId: number, canViewAll: boolean): Promise<{
        entries: TimeEntryResponse[];
        pagination: {
            page: number;
            limit: number;
            total: any;
            totalPages: number;
        };
    }>;
    getTimeEntryById(id: number, currentUserId: number, canViewAll: boolean): Promise<TimeEntryResponse | null>;
    createTimeEntry(data: CreateTimeEntryDto, userId: number): Promise<TimeEntryResponse | null>;
    updateTimeEntry(id: number, data: UpdateTimeEntryDto, userId: number, canViewAll: boolean): Promise<TimeEntryResponse | null>;
    deleteTimeEntry(id: number, userId: number, canViewAll: boolean): Promise<void>;
    submitTimeEntries(entryIds: number[], userId: number): Promise<void>;
    approveTimeEntries(entryIds: number[], approverId: number): Promise<void>;
    rejectTimeEntries(entryIds: number[], approverId: number, reason: string): Promise<void>;
    getRunningTimer(userId: number): Promise<RunningTimerResponse | null>;
    startTimer(data: StartTimerDto, userId: number): Promise<RunningTimerResponse | null>;
    stopTimer(userId: number): Promise<TimeEntryResponse | null>;
    listActivityCodes(activeOnly?: boolean): Promise<ActivityCodeResponse[]>;
    getActivityCodeById(id: number): Promise<ActivityCodeResponse | null>;
    createActivityCode(data: CreateActivityCodeDto): Promise<ActivityCodeResponse | null>;
    updateActivityCode(id: number, data: UpdateActivityCodeDto): Promise<ActivityCodeResponse | null>;
}
export declare const timeRepo: TimeRepository;
//# sourceMappingURL=repo.d.ts.map