import { z } from 'zod';
export declare const createTrustAccountSchema: z.ZodObject<{
    client_id: z.ZodNumber;
    matter_id: z.ZodOptional<z.ZodNumber>;
    account_name: z.ZodString;
    account_number: z.ZodOptional<z.ZodString>;
    bank_name: z.ZodOptional<z.ZodString>;
    currency: z.ZodDefault<z.ZodString>;
    account_type: z.ZodDefault<z.ZodEnum<["Client Trust", "Matter Trust", "General Trust"]>>;
    notes: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    client_id: number;
    currency: string;
    account_name: string;
    account_type: "Client Trust" | "Matter Trust" | "General Trust";
    matter_id?: number | undefined;
    notes?: string | undefined;
    bank_name?: string | undefined;
    account_number?: string | undefined;
}, {
    client_id: number;
    account_name: string;
    matter_id?: number | undefined;
    notes?: string | undefined;
    currency?: string | undefined;
    bank_name?: string | undefined;
    account_number?: string | undefined;
    account_type?: "Client Trust" | "Matter Trust" | "General Trust" | undefined;
}>;
export type CreateTrustAccountDto = z.infer<typeof createTrustAccountSchema>;
export declare const updateTrustAccountSchema: z.ZodObject<{
    account_name: z.ZodOptional<z.ZodString>;
    account_number: z.ZodOptional<z.ZodString>;
    bank_name: z.ZodOptional<z.ZodString>;
    notes: z.ZodOptional<z.ZodString>;
    is_active: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    is_active?: boolean | undefined;
    notes?: string | undefined;
    bank_name?: string | undefined;
    account_name?: string | undefined;
    account_number?: string | undefined;
}, {
    is_active?: boolean | undefined;
    notes?: string | undefined;
    bank_name?: string | undefined;
    account_name?: string | undefined;
    account_number?: string | undefined;
}>;
export type UpdateTrustAccountDto = z.infer<typeof updateTrustAccountSchema>;
export declare const createTrustTransactionSchema: z.ZodObject<{
    trust_account_id: z.ZodNumber;
    transaction_type: z.ZodEnum<["Deposit", "Withdrawal", "Transfer Out", "Transfer In", "Fee Transfer", "Refund"]>;
    amount: z.ZodNumber;
    transaction_date: z.ZodString;
    reference_number: z.ZodOptional<z.ZodString>;
    description: z.ZodString;
    payment_method: z.ZodOptional<z.ZodString>;
    payee: z.ZodOptional<z.ZodString>;
    related_invoice_id: z.ZodOptional<z.ZodNumber>;
    related_matter_id: z.ZodOptional<z.ZodNumber>;
    requires_approval: z.ZodDefault<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    description: string;
    amount: number;
    trust_account_id: number;
    transaction_type: "Deposit" | "Withdrawal" | "Transfer Out" | "Transfer In" | "Fee Transfer" | "Refund";
    transaction_date: string;
    requires_approval: boolean;
    payment_method?: string | undefined;
    reference_number?: string | undefined;
    payee?: string | undefined;
    related_invoice_id?: number | undefined;
    related_matter_id?: number | undefined;
}, {
    description: string;
    amount: number;
    trust_account_id: number;
    transaction_type: "Deposit" | "Withdrawal" | "Transfer Out" | "Transfer In" | "Fee Transfer" | "Refund";
    transaction_date: string;
    payment_method?: string | undefined;
    reference_number?: string | undefined;
    payee?: string | undefined;
    related_invoice_id?: number | undefined;
    related_matter_id?: number | undefined;
    requires_approval?: boolean | undefined;
}>;
export type CreateTrustTransactionDto = z.infer<typeof createTrustTransactionSchema>;
export declare const transferBetweenTrustSchema: z.ZodObject<{
    from_account_id: z.ZodNumber;
    to_account_id: z.ZodNumber;
    amount: z.ZodNumber;
    transaction_date: z.ZodString;
    description: z.ZodString;
    reference_number: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    description: string;
    amount: number;
    transaction_date: string;
    from_account_id: number;
    to_account_id: number;
    reference_number?: string | undefined;
}, {
    description: string;
    amount: number;
    transaction_date: string;
    from_account_id: number;
    to_account_id: number;
    reference_number?: string | undefined;
}>;
export type TransferBetweenTrustDto = z.infer<typeof transferBetweenTrustSchema>;
export declare const approveTrustTransactionSchema: z.ZodObject<{
    approval_notes: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    approval_notes?: string | undefined;
}, {
    approval_notes?: string | undefined;
}>;
export type ApproveTrustTransactionDto = z.infer<typeof approveTrustTransactionSchema>;
export declare const rejectTrustTransactionSchema: z.ZodObject<{
    rejection_reason: z.ZodString;
}, "strip", z.ZodTypeAny, {
    rejection_reason: string;
}, {
    rejection_reason: string;
}>;
export type RejectTrustTransactionDto = z.infer<typeof rejectTrustTransactionSchema>;
export declare const queryTrustTransactionsSchema: z.ZodObject<{
    page: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    limit: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    trust_account_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    transaction_type: z.ZodOptional<z.ZodEnum<["Deposit", "Withdrawal", "Transfer Out", "Transfer In", "Fee Transfer", "Refund"]>>;
    status: z.ZodOptional<z.ZodEnum<["Pending", "Approved", "Rejected", "Posted"]>>;
    start_date: z.ZodOptional<z.ZodString>;
    end_date: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    page: number;
    limit: number;
    status?: "Pending" | "Approved" | "Rejected" | "Posted" | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    trust_account_id?: number | undefined;
    transaction_type?: "Deposit" | "Withdrawal" | "Transfer Out" | "Transfer In" | "Fee Transfer" | "Refund" | undefined;
}, {
    status?: "Pending" | "Approved" | "Rejected" | "Posted" | undefined;
    page?: string | undefined;
    limit?: string | undefined;
    start_date?: string | undefined;
    end_date?: string | undefined;
    trust_account_id?: string | undefined;
    transaction_type?: "Deposit" | "Withdrawal" | "Transfer Out" | "Transfer In" | "Fee Transfer" | "Refund" | undefined;
}>;
export type QueryTrustTransactionsDto = z.infer<typeof queryTrustTransactionsSchema>;
export declare const createTrustReconciliationSchema: z.ZodObject<{
    trust_account_id: z.ZodNumber;
    reconciliation_date: z.ZodString;
    bank_statement_balance: z.ZodNumber;
    book_balance: z.ZodNumber;
    reconciled_balance: z.ZodNumber;
    unreconciled_items: z.ZodOptional<z.ZodString>;
    notes: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    trust_account_id: number;
    reconciliation_date: string;
    bank_statement_balance: number;
    book_balance: number;
    reconciled_balance: number;
    notes?: string | undefined;
    unreconciled_items?: string | undefined;
}, {
    trust_account_id: number;
    reconciliation_date: string;
    bank_statement_balance: number;
    book_balance: number;
    reconciled_balance: number;
    notes?: string | undefined;
    unreconciled_items?: string | undefined;
}>;
export type CreateTrustReconciliationDto = z.infer<typeof createTrustReconciliationSchema>;
export declare const updateTrustReconciliationSchema: z.ZodObject<{
    bank_statement_balance: z.ZodOptional<z.ZodNumber>;
    reconciled_balance: z.ZodOptional<z.ZodNumber>;
    unreconciled_items: z.ZodOptional<z.ZodString>;
    notes: z.ZodOptional<z.ZodString>;
    status: z.ZodOptional<z.ZodEnum<["Draft", "Completed", "Reviewed"]>>;
}, "strip", z.ZodTypeAny, {
    status?: "Completed" | "Draft" | "Reviewed" | undefined;
    notes?: string | undefined;
    bank_statement_balance?: number | undefined;
    reconciled_balance?: number | undefined;
    unreconciled_items?: string | undefined;
}, {
    status?: "Completed" | "Draft" | "Reviewed" | undefined;
    notes?: string | undefined;
    bank_statement_balance?: number | undefined;
    reconciled_balance?: number | undefined;
    unreconciled_items?: string | undefined;
}>;
export type UpdateTrustReconciliationDto = z.infer<typeof updateTrustReconciliationSchema>;
export interface TrustAccountResponse {
    id: number;
    client_id: number;
    client_name: string;
    matter_id: number | null;
    matter_number: string | null;
    matter_title: string | null;
    account_name: string;
    account_number: string | null;
    bank_name: string | null;
    currency: string;
    account_type: 'Client Trust' | 'Matter Trust' | 'General Trust';
    current_balance: number;
    notes: string | null;
    is_active: boolean;
    created_by: number;
    created_by_name: string;
    created_at: string;
    updated_at: string;
}
export interface TrustTransactionResponse {
    id: number;
    trust_account_id: number;
    trust_account_name: string;
    transaction_type: 'Deposit' | 'Withdrawal' | 'Transfer Out' | 'Transfer In' | 'Fee Transfer' | 'Refund';
    amount: number;
    balance_after: number;
    transaction_date: string;
    reference_number: string | null;
    description: string;
    payment_method: string | null;
    payee: string | null;
    related_invoice_id: number | null;
    related_matter_id: number | null;
    status: 'Pending' | 'Approved' | 'Rejected' | 'Posted';
    requires_approval: boolean;
    created_by: number;
    created_by_name: string;
    approved_by: number | null;
    approved_by_name: string | null;
    approved_at: string | null;
    approval_notes: string | null;
    rejection_reason: string | null;
    posted_at: string | null;
    is_reversed: boolean;
    reversal_of_id: number | null;
    created_at: string;
    updated_at: string;
}
export interface TrustReconciliationResponse {
    id: number;
    trust_account_id: number;
    trust_account_name: string;
    reconciliation_date: string;
    bank_statement_balance: number;
    book_balance: number;
    reconciled_balance: number;
    difference: number;
    unreconciled_items: string | null;
    notes: string | null;
    status: 'Draft' | 'Completed' | 'Reviewed';
    reconciled_by: number;
    reconciled_by_name: string;
    reviewed_by: number | null;
    reviewed_by_name: string | null;
    reviewed_at: string | null;
    created_at: string;
    updated_at: string;
}
export interface TrustSummaryResponse {
    total_accounts: number;
    active_accounts: number;
    total_balance: number;
    pending_approvals: number;
    pending_amount: number;
    last_reconciliation_date: string | null;
    by_account_type: {
        account_type: string;
        count: number;
        total_balance: number;
    }[];
}
//# sourceMappingURL=dto.d.ts.map