import type { CreateTrustAccountDto, UpdateTrustAccountDto, CreateTrustTransactionDto, TransferBetweenTrustDto, ApproveTrustTransactionDto, RejectTrustTransactionDto, QueryTrustTransactionsDto, CreateTrustReconciliationDto, UpdateTrustReconciliationDto, TrustAccountResponse, TrustTransactionResponse, TrustReconciliationResponse, TrustSummaryResponse } from './dto.js';
export declare class TrustRepository {
    listTrustAccounts(clientId?: number, isActive?: boolean): Promise<TrustAccountResponse[]>;
    getTrustAccountById(id: number): Promise<TrustAccountResponse | null>;
    createTrustAccount(data: CreateTrustAccountDto, userId: number): Promise<TrustAccountResponse | null>;
    updateTrustAccount(id: number, data: UpdateTrustAccountDto): Promise<TrustAccountResponse | null>;
    listTrustTransactions(query: QueryTrustTransactionsDto): Promise<{
        transactions: TrustTransactionResponse[];
        pagination: {
            page: number;
            limit: number;
            total: any;
            totalPages: number;
        };
    }>;
    getTrustTransactionById(id: number): Promise<TrustTransactionResponse | null>;
    createTrustTransaction(data: CreateTrustTransactionDto, userId: number): Promise<TrustTransactionResponse | null>;
    transferBetweenTrust(data: TransferBetweenTrustDto, userId: number): Promise<{
        from: TrustTransactionResponse | null;
        to: TrustTransactionResponse | null;
    }>;
    approveTrustTransaction(id: number, userId: number, data: ApproveTrustTransactionDto): Promise<TrustTransactionResponse | null>;
    rejectTrustTransaction(id: number, userId: number, data: RejectTrustTransactionDto): Promise<TrustTransactionResponse | null>;
    listTrustReconciliations(trustAccountId?: number): Promise<TrustReconciliationResponse[]>;
    getTrustReconciliationById(id: number): Promise<TrustReconciliationResponse | null>;
    createTrustReconciliation(data: CreateTrustReconciliationDto, userId: number): Promise<TrustReconciliationResponse | null>;
    updateTrustReconciliation(id: number, data: UpdateTrustReconciliationDto): Promise<TrustReconciliationResponse | null>;
    reviewTrustReconciliation(id: number, userId: number): Promise<TrustReconciliationResponse | null>;
    getTrustSummary(): Promise<TrustSummaryResponse>;
}
export declare const trustRepo: TrustRepository;
//# sourceMappingURL=repo.d.ts.map