import { z } from 'zod';
export declare const createUserSchema: z.ZodObject<{
    body: z.ZodObject<{
        username: z.ZodString;
        password: z.ZodString;
        employee_id: z.ZodNumber;
        role_id: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        password: string;
        username: string;
        employee_id: number;
        role_id: number;
    }, {
        password: string;
        username: string;
        employee_id: number;
        role_id: number;
    }>;
}, "strip", z.ZodTypeAny, {
    body: {
        password: string;
        username: string;
        employee_id: number;
        role_id: number;
    };
}, {
    body: {
        password: string;
        username: string;
        employee_id: number;
        role_id: number;
    };
}>;
export declare const updateUserSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        id: string;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        username: z.ZodOptional<z.ZodString>;
        password: z.ZodOptional<z.ZodString>;
        employee_id: z.ZodOptional<z.ZodNumber>;
        role_id: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        password?: string | undefined;
        username?: string | undefined;
        employee_id?: number | undefined;
        role_id?: number | undefined;
    }, {
        password?: string | undefined;
        username?: string | undefined;
        employee_id?: number | undefined;
        role_id?: number | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: string;
    };
    body: {
        password?: string | undefined;
        username?: string | undefined;
        employee_id?: number | undefined;
        role_id?: number | undefined;
    };
}, {
    params: {
        id: string;
    };
    body: {
        password?: string | undefined;
        username?: string | undefined;
        employee_id?: number | undefined;
        role_id?: number | undefined;
    };
}>;
export declare const deleteUserSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        id: string;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: string;
    };
}, {
    params: {
        id: string;
    };
}>;
export declare const getUserSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        id: string;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: string;
    };
}, {
    params: {
        id: string;
    };
}>;
export type CreateUserDto = z.infer<typeof createUserSchema>['body'];
export type UpdateUserDto = z.infer<typeof updateUserSchema>['body'];
export interface UserResponse {
    id: number;
    username: string;
    employee_id: number;
    employee_name: string;
    role_id: number;
    role_name: string;
    department_id: number;
    department_name: string;
    created_at: Date;
}
//# sourceMappingURL=dto.d.ts.map