import { z } from 'zod';
// Create user DTO
export const createUserSchema = z.object({
    body: z.object({
        username: z.string().min(3, 'Username must be at least 3 characters').max(50),
        password: z.string().min(8, 'Password must be at least 8 characters'),
        employee_id: z.number().int().positive('Employee is required'),
        role_id: z.number().int().positive('Role is required'),
    }),
});
// Update user DTO
export const updateUserSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/, 'Invalid user ID'),
    }),
    body: z.object({
        username: z.string().min(3).max(50).optional(),
        password: z.string().min(8).optional(),
        employee_id: z.number().int().positive().optional(),
        role_id: z.number().int().positive().optional(),
    }),
});
// Delete user DTO
export const deleteUserSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/, 'Invalid user ID'),
    }),
});
// Get user DTO
export const getUserSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/, 'Invalid user ID'),
    }),
});
//# sourceMappingURL=dto.js.map