import { CreateUserDto, UpdateUserDto, UserResponse } from './dto.js';
export declare class UserRepository {
    /**
     * Get all users with employee, role, and department info
     */
    findAll(): Promise<UserResponse[]>;
    /**
     * Get user by ID
     */
    findById(id: number): Promise<UserResponse | null>;
    /**
     * Check if username exists (excluding specific ID for updates)
     */
    usernameExists(username: string, excludeId?: number): Promise<boolean>;
    /**
     * Check if employee already has a user account
     */
    employeeHasUser(employeeId: number, excludeUserId?: number): Promise<boolean>;
    /**
     * Check if employee exists
     */
    employeeExists(employeeId: number): Promise<boolean>;
    /**
     * Check if role exists
     */
    roleExists(roleId: number): Promise<boolean>;
    /**
     * Create user
     */
    create(data: CreateUserDto): Promise<UserResponse>;
    /**
     * Update user
     */
    update(id: number, data: UpdateUserDto): Promise<UserResponse>;
    /**
     * Delete user
     */
    delete(id: number): Promise<void>;
    /**
     * Log user action to audit log
     */
    logAction(userId: number, targetUserId: number, action: 'CREATE' | 'UPDATE' | 'DELETE', meta: Record<string, any>): Promise<void>;
}
//# sourceMappingURL=repo.d.ts.map