import { z } from 'zod';
export declare const queryWIPSummarySchema: z.ZodObject<{
    matter_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    client_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    min_balance: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
}, "strip", z.ZodTypeAny, {
    client_id?: number | undefined;
    matter_id?: number | undefined;
    min_balance?: number | undefined;
}, {
    client_id?: string | undefined;
    matter_id?: string | undefined;
    min_balance?: string | undefined;
}>;
export type QueryWIPSummaryDto = z.infer<typeof queryWIPSummarySchema>;
export declare const queryRevenueSchema: z.ZodObject<{
    page: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    limit: z.ZodEffects<z.ZodOptional<z.ZodString>, number, string | undefined>;
    matter_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    client_id: z.ZodEffects<z.ZodOptional<z.ZodString>, number | undefined, string | undefined>;
    start_month: z.ZodOptional<z.ZodString>;
    end_month: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    page: number;
    limit: number;
    client_id?: number | undefined;
    matter_id?: number | undefined;
    start_month?: string | undefined;
    end_month?: string | undefined;
}, {
    client_id?: string | undefined;
    page?: string | undefined;
    limit?: string | undefined;
    matter_id?: string | undefined;
    start_month?: string | undefined;
    end_month?: string | undefined;
}>;
export type QueryRevenueDto = z.infer<typeof queryRevenueSchema>;
export declare const createRevenueSchema: z.ZodObject<{
    matter_id: z.ZodNumber;
    recognition_month: z.ZodString;
    time_value: z.ZodDefault<z.ZodNumber>;
    expense_value: z.ZodDefault<z.ZodNumber>;
    total_value: z.ZodNumber;
    invoiced_amount: z.ZodDefault<z.ZodNumber>;
    collected_amount: z.ZodDefault<z.ZodNumber>;
    notes: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    matter_id: number;
    recognition_month: string;
    time_value: number;
    expense_value: number;
    total_value: number;
    invoiced_amount: number;
    collected_amount: number;
    notes?: string | undefined;
}, {
    matter_id: number;
    recognition_month: string;
    total_value: number;
    notes?: string | undefined;
    time_value?: number | undefined;
    expense_value?: number | undefined;
    invoiced_amount?: number | undefined;
    collected_amount?: number | undefined;
}>;
export type CreateRevenueDto = z.infer<typeof createRevenueSchema>;
export declare const updateRevenueSchema: z.ZodObject<{
    time_value: z.ZodOptional<z.ZodNumber>;
    expense_value: z.ZodOptional<z.ZodNumber>;
    total_value: z.ZodOptional<z.ZodNumber>;
    invoiced_amount: z.ZodOptional<z.ZodNumber>;
    collected_amount: z.ZodOptional<z.ZodNumber>;
    notes: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    notes?: string | undefined;
    time_value?: number | undefined;
    expense_value?: number | undefined;
    total_value?: number | undefined;
    invoiced_amount?: number | undefined;
    collected_amount?: number | undefined;
}, {
    notes?: string | undefined;
    time_value?: number | undefined;
    expense_value?: number | undefined;
    total_value?: number | undefined;
    invoiced_amount?: number | undefined;
    collected_amount?: number | undefined;
}>;
export type UpdateRevenueDto = z.infer<typeof updateRevenueSchema>;
export interface WIPSummaryResponse {
    id: number;
    matter_id: number;
    matter_number: string | null;
    matter_title: string;
    client_id: number;
    client_name: string;
    unbilled_time_hours: number;
    unbilled_time_value: number;
    unbilled_expenses: number;
    total_wip: number;
    last_invoice_date: string | null;
    oldest_unbilled_date: string | null;
    last_updated: string;
}
export interface RevenueRecognitionResponse {
    id: number;
    matter_id: number;
    matter_number: string | null;
    matter_title: string;
    client_id: number;
    client_name: string;
    recognition_month: string;
    time_value: number;
    expense_value: number;
    total_value: number;
    invoiced_amount: number;
    collected_amount: number;
    unbilled_value: number;
    uncollected_value: number;
    notes: string | null;
    created_by: number;
    created_by_name: string;
    created_at: string;
    updated_at: string;
}
export interface WIPAnalyticsResponse {
    total_wip_value: number;
    total_unbilled_time: number;
    total_unbilled_expenses: number;
    avg_days_unbilled: number;
    matters_with_wip: number;
    top_wip_matters: {
        matter_id: number;
        matter_number: string | null;
        matter_title: string;
        client_name: string;
        wip_value: number;
    }[];
    wip_by_client: {
        client_id: number;
        client_name: string;
        wip_value: number;
        matter_count: number;
    }[];
}
export interface RevenueAnalyticsResponse {
    total_recognized: number;
    total_invoiced: number;
    total_collected: number;
    total_unbilled: number;
    total_uncollected: number;
    collection_rate: number;
    realization_rate: number;
    by_month: {
        month: string;
        recognized: number;
        invoiced: number;
        collected: number;
    }[];
}
//# sourceMappingURL=dto.d.ts.map