import { z } from 'zod';
// ================================================
// WIP Summary DTOs
// ================================================
// Query WIP Summary
export const queryWIPSummarySchema = z.object({
    matter_id: z.string().optional().transform(val => val ? parseInt(val) : undefined),
    client_id: z.string().optional().transform(val => val ? parseInt(val) : undefined),
    min_balance: z.string().optional().transform(val => val ? parseFloat(val) : undefined),
});
// ================================================
// Revenue Recognition DTOs
// ================================================
// Query Revenue Recognition
export const queryRevenueSchema = z.object({
    page: z.string().optional().transform(val => val ? parseInt(val) : 1),
    limit: z.string().optional().transform(val => val ? parseInt(val) : 50),
    matter_id: z.string().optional().transform(val => val ? parseInt(val) : undefined),
    client_id: z.string().optional().transform(val => val ? parseInt(val) : undefined),
    start_month: z.string().regex(/^\d{4}-\d{2}$/).optional(),
    end_month: z.string().regex(/^\d{4}-\d{2}$/).optional(),
});
// Create Revenue Recognition Entry
export const createRevenueSchema = z.object({
    matter_id: z.number().int().positive(),
    recognition_month: z.string().regex(/^\d{4}-\d{2}$/),
    time_value: z.number().min(0).default(0),
    expense_value: z.number().min(0).default(0),
    total_value: z.number().min(0),
    invoiced_amount: z.number().min(0).default(0),
    collected_amount: z.number().min(0).default(0),
    notes: z.string().max(2000).optional(),
});
// Update Revenue Recognition Entry
export const updateRevenueSchema = z.object({
    time_value: z.number().min(0).optional(),
    expense_value: z.number().min(0).optional(),
    total_value: z.number().min(0).optional(),
    invoiced_amount: z.number().min(0).optional(),
    collected_amount: z.number().min(0).optional(),
    notes: z.string().max(2000).optional(),
});
//# sourceMappingURL=dto.js.map