import type { QueryWIPSummaryDto, QueryRevenueDto, CreateRevenueDto, UpdateRevenueDto, WIPSummaryResponse, RevenueRecognitionResponse, WIPAnalyticsResponse, RevenueAnalyticsResponse } from './dto.js';
export declare class WIPRepository {
    refreshWIPSummary(matterId?: number): Promise<void>;
    listWIPSummary(query: QueryWIPSummaryDto): Promise<WIPSummaryResponse[]>;
    getWIPAnalytics(): Promise<WIPAnalyticsResponse>;
    listRevenueRecognition(query: QueryRevenueDto): Promise<{
        revenue: RevenueRecognitionResponse[];
        pagination: {
            page: number;
            limit: number;
            total: any;
            totalPages: number;
        };
    }>;
    getRevenueRecognitionById(id: number): Promise<RevenueRecognitionResponse | null>;
    createRevenueRecognition(data: CreateRevenueDto, userId: number): Promise<RevenueRecognitionResponse | null>;
    updateRevenueRecognition(id: number, data: UpdateRevenueDto): Promise<RevenueRecognitionResponse | null>;
    getRevenueAnalytics(startMonth?: string, endMonth?: string): Promise<RevenueAnalyticsResponse>;
    autoGenerateRevenueForMonth(month: string, userId: number): Promise<number>;
}
export declare const wipRepo: WIPRepository;
//# sourceMappingURL=repo.d.ts.map