import { z } from 'zod';
export declare const createWorkflowSchema: z.ZodObject<{
    body: z.ZodObject<{
        workflow_name: z.ZodString;
        description: z.ZodOptional<z.ZodString>;
        stages: z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            order: z.ZodNumber;
            sla_hours: z.ZodNullable<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            order: number;
            sla_hours: number | null;
        }, {
            name: string;
            order: number;
            sla_hours: number | null;
        }>, "many">;
        is_default: z.ZodDefault<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        workflow_name: string;
        stages: {
            name: string;
            order: number;
            sla_hours: number | null;
        }[];
        is_default: boolean;
        description?: string | undefined;
    }, {
        workflow_name: string;
        stages: {
            name: string;
            order: number;
            sla_hours: number | null;
        }[];
        description?: string | undefined;
        is_default?: boolean | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    body: {
        workflow_name: string;
        stages: {
            name: string;
            order: number;
            sla_hours: number | null;
        }[];
        is_default: boolean;
        description?: string | undefined;
    };
}, {
    body: {
        workflow_name: string;
        stages: {
            name: string;
            order: number;
            sla_hours: number | null;
        }[];
        description?: string | undefined;
        is_default?: boolean | undefined;
    };
}>;
export declare const updateWorkflowSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        workflow_name: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        stages: z.ZodOptional<z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            order: z.ZodNumber;
            sla_hours: z.ZodNullable<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            order: number;
            sla_hours: number | null;
        }, {
            name: string;
            order: number;
            sla_hours: number | null;
        }>, "many">>;
        is_default: z.ZodOptional<z.ZodBoolean>;
        is_active: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        is_active?: boolean | undefined;
        description?: string | undefined;
        workflow_name?: string | undefined;
        stages?: {
            name: string;
            order: number;
            sla_hours: number | null;
        }[] | undefined;
        is_default?: boolean | undefined;
    }, {
        is_active?: boolean | undefined;
        description?: string | undefined;
        workflow_name?: string | undefined;
        stages?: {
            name: string;
            order: number;
            sla_hours: number | null;
        }[] | undefined;
        is_default?: boolean | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
    body: {
        is_active?: boolean | undefined;
        description?: string | undefined;
        workflow_name?: string | undefined;
        stages?: {
            name: string;
            order: number;
            sla_hours: number | null;
        }[] | undefined;
        is_default?: boolean | undefined;
    };
}, {
    params: {
        id: string;
    };
    body: {
        is_active?: boolean | undefined;
        description?: string | undefined;
        workflow_name?: string | undefined;
        stages?: {
            name: string;
            order: number;
            sla_hours: number | null;
        }[] | undefined;
        is_default?: boolean | undefined;
    };
}>;
export declare const getWorkflowSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
}, {
    params: {
        id: string;
    };
}>;
export declare const transitionStageSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
    body: z.ZodObject<{
        stage: z.ZodString;
        transition_reason: z.ZodOptional<z.ZodString>;
        notes: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        stage: string;
        transition_reason?: string | undefined;
        notes?: string | undefined;
    }, {
        stage: string;
        transition_reason?: string | undefined;
        notes?: string | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
    body: {
        stage: string;
        transition_reason?: string | undefined;
        notes?: string | undefined;
    };
}, {
    params: {
        id: string;
    };
    body: {
        stage: string;
        transition_reason?: string | undefined;
        notes?: string | undefined;
    };
}>;
export declare const getMatterStagesSchema: z.ZodObject<{
    params: z.ZodObject<{
        id: z.ZodEffects<z.ZodString, number, string>;
    }, "strip", z.ZodTypeAny, {
        id: number;
    }, {
        id: string;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        id: number;
    };
}, {
    params: {
        id: string;
    };
}>;
export type CreateWorkflowDto = z.infer<typeof createWorkflowSchema>['body'];
export type UpdateWorkflowDto = z.infer<typeof updateWorkflowSchema>['body'];
export type TransitionStageDto = z.infer<typeof transitionStageSchema>['body'];
export interface WorkflowStage {
    name: string;
    order: number;
    sla_hours: number | null;
}
export interface WorkflowResponse {
    id: number;
    workflow_name: string;
    description: string | null;
    stages: WorkflowStage[];
    is_default: boolean;
    is_active: boolean;
    created_by: number | null;
    created_by_name: string | null;
    created_at: string;
    updated_at: string;
}
export interface MatterStageResponse {
    id: number;
    matter_id: number;
    stage: string;
    stage_order: number;
    started_at: string;
    ended_at: string | null;
    sla_hours: number | null;
    sla_due_at: string | null;
    is_overdue: boolean;
    transition_reason: string | null;
    notes: string | null;
    transitioned_by: number | null;
    transitioned_by_name: string | null;
    created_at: string;
}
//# sourceMappingURL=dto.d.ts.map