import { z } from 'zod';
// ====================
// Request Schemas
// ====================
export const createWorkflowSchema = z.object({
    body: z.object({
        workflow_name: z.string().min(3).max(100),
        description: z.string().optional(),
        stages: z.array(z.object({
            name: z.string().min(2).max(100),
            order: z.number().int().positive(),
            sla_hours: z.number().int().positive().nullable(),
        })).min(2, 'Workflow must have at least 2 stages'),
        is_default: z.boolean().default(false),
    }),
});
export const updateWorkflowSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
    body: z.object({
        workflow_name: z.string().min(3).max(100).optional(),
        description: z.string().optional(),
        stages: z.array(z.object({
            name: z.string().min(2).max(100),
            order: z.number().int().positive(),
            sla_hours: z.number().int().positive().nullable(),
        })).min(2).optional(),
        is_default: z.boolean().optional(),
        is_active: z.boolean().optional(),
    }),
});
export const getWorkflowSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
});
export const transitionStageSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
    body: z.object({
        stage: z.string().min(2).max(100),
        transition_reason: z.string().optional(),
        notes: z.string().optional(),
    }),
});
export const getMatterStagesSchema = z.object({
    params: z.object({
        id: z.string().regex(/^\d+$/).transform(Number),
    }),
});
//# sourceMappingURL=dto.js.map