import { CreateWorkflowDto, UpdateWorkflowDto, TransitionStageDto, WorkflowResponse, MatterStageResponse } from './dto.js';
export declare class WorkflowRepository {
    /**
     * Get all workflows
     */
    findAll(): Promise<WorkflowResponse[]>;
    /**
     * Find workflow by ID
     */
    findById(id: number): Promise<WorkflowResponse | null>;
    /**
     * Create workflow
     */
    create(data: CreateWorkflowDto, userId: number): Promise<number>;
    /**
     * Update workflow
     */
    update(id: number, data: UpdateWorkflowDto): Promise<boolean>;
    /**
     * Transition matter to new stage
     */
    transitionStage(matterId: number, data: TransitionStageDto, userId: number): Promise<number>;
    /**
     * Get stage history for a matter
     */
    getMatterStages(matterId: number): Promise<MatterStageResponse[]>;
    /**
     * Get all overdue matters
     */
    getOverdueMatters(): Promise<any[]>;
}
//# sourceMappingURL=repo.d.ts.map