import pino from 'pino';
import { config } from '../config.js';
export const logger = pino({
    level: config.LOG_LEVEL,
    formatters: {
        level: (label) => {
            return { level: label };
        },
    },
    serializers: {
        req: (req) => ({
            id: req.id,
            method: req.method,
            url: req.url,
            headers: {
                host: req.headers.host,
                userAgent: req.headers['user-agent'],
            },
        }),
        res: (res) => ({
            statusCode: res.statusCode,
        }),
        err: pino.stdSerializers.err,
    },
});
export const createRequestLogger = () => {
    return (req, res, next) => {
        const requestId = Math.random().toString(36).substring(2, 15);
        req.id = requestId;
        req.log = logger.child({ requestId });
        const start = Date.now();
        res.on('finish', () => {
            const duration = Date.now() - start;
            req.log.info({
                req,
                res,
                duration,
            }, `${req.method} ${req.url} ${res.statusCode} - ${duration}ms`);
        });
        next();
    };
};
//# sourceMappingURL=logger.js.map